import GhostCta from "@/components/GhostwritingPage/Cta/GhostCta";
import FAQSection from "@/components/GhostwritingPage/FAQSection/FAQSection";
import GhostwritingSection from "@/components/GhostwritingPage/GhostwritingSec/GhostwritingSec";
import GhostwritingWorkflow from "@/components/GhostwritingPage/GhostwritingWorkflow/GhostwritingWorkflow";
import Hero from "@/components/GhostwritingPage/HeroSec/Hero";
import WhyChooseSection from "@/components/GhostwritingPage/WhyChooseSec/WhyChooseSec";
import ContactForm from "@/components/landingPage/ContactForm/ContactForm";
import PortfolioSection from "@/components/landingPage/PortfolioSec/PortfolioSec";
import Image from "next/image";

export const metadata = {
  title: "Best Article Writing Services | Get Published Now",
  description:
    "Professional article writing and publishing services. From short stories to SEO blogs we help you write, polish, and get published.",
};

const heroData = {
  heading1: (
    <h1 className="hero-titles">
      <span className="hero-title-highlight">
        Best <span className="black">Article Writing Services</span> for Every
        Platform
      </span>
    </h1>
  ),
  para: "Get featured with Elume’s best article writing services crafted to inform, engage, and publish. From blogs to magazines, we help authors and experts get professionally written content published in the right places.",
};

const ghostData = {
  heading1: (
    <>
      <h1 className="ghostwriting-title-black">What Is</h1>
      <h1 className="ghostwriting-title-orange">Article Writing?</h1>
    </>
  ),
  para1:
    "Article writing and publishing involves creating high-quality, research-based or opinion-driven content for digital or print platforms. Whether you’re writing an article for publishing in a journal, blog, or magazine, Elume delivers clarity, strategy, and polish.",
  para2:
    "As a trusted article writing agency, we help authors, educators, and thought leaders craft powerful pieces from how-to guides to published articles on short story writing, lifestyle, education, business, and more.",
  image: (
    <Image
      src="/proof1.webp"
      alt="Ghostwriting illustration"
      width={694}
      height={553}
      className="ghostwriting-image"
    />
  ),
};

const ghostCta = {
  heading1: (
    <h1 className="hero-main-title">
      You Have Something to Say <br />
      <span className="text-orange">We Help</span> You Say It,{" "}
      <span className="text-orange">and Get It Seen.</span>
    </h1>
  ),
  image: (
    <Image
      src="/bookedit2.webp"
      alt="Ghost writing promotional banner"
      width={1600}
      height={437}
      className="hero-background-image"
    />
  ),
};

const chooseSec = {
  features: (
    <ul>
      <li>We’re more than writers we’re strategic content creators.</li>
      <li>Trusted by authors, educators, and entrepreneurs</li>
      <li> Expert editing and keyword optimization</li>
      <li>Broad publishing outreach</li>
      <li>Top-rated article writing agency services</li>
      <li> Let’s get your article written, refined, and published.</li>
    </ul>
  ),

  heading1: <h2 className="why-choose-title">Why Choose Elume Publishers?</h2>,
  image: (
    <Image
      src="/bookleft.webp"
      width={785}
      height={664}
      alt="Book cover showcase"
      className="book-main"
    />
  ),
};

const ghostWorkflow = {
  mainHeading: (
    <h1 className="workflow-title">
      How Does Our{" "}
      <span className="text-orange">Article Writing & Publishing</span> Process
      Work?
    </h1>
  ),
  mainPara:
    "Our article writing and publishing process transforms your ideas into polished, publish-ready content with research, writing, editing, and submission support tailored to your goals and the right platforms.",

  heading1: <h3 className="step-title orange">Define Your Topic & Goal</h3>,
  para1:
    "We begin by understanding your topic, audience, and publishing goals. Whether you're writing an article for publishing in an academic journal or aiming for SEO traffic, we tailor the tone and structure to meet your objective and target platform.",

  heading2: <h3 className="step-title gray">Research, Write & Edit</h3>,
  para2:
    "Our writers handle in-depth research, original content creation, and editing. From professional features to published articles on short story writing, we ensure clarity, flow, and factual accuracy while aligning your voice with your publication’s standards.",

  heading3: (
    <h3 className="step-title orange">Format & Submit for Publishing </h3>
  ),
  para3:
    "We finalize your article with the correct format and guidelines for submission. Whether self-publishing, guest posting, or submitting to major outlets, our best article writing services make sure your work is ready and professionally presented.",
};

const faqs = [
  {
    question: "What’s included in your article writing services?",
    answer:
      "Our best article writing services include topic planning, research, writing, editing, formatting, and publishing support ideal for blogs, websites, journals, and guest features.",
  },
  {
    question: " Do you help with writing an article for publishing?",
    answer:
      "Yes! We assist with writing an article for publishing by refining your message, optimizing structure, and preparing it for submission to your desired platform or publication.",
  },
  {
    question: "What types of articles do you write?",
    answer:
      "We cover everything from blog posts and professional essays to published articles on short story writing, business, lifestyle, health, education, and more.",
  },
  {
    question: "Can you publish the article for me too?",
    answer:
      "Yes! As a full-service article writing agency, we offer both writing and placement support helping you get published on blogs, websites, media outlets, and industry platforms.",
  },
  {
    question: "How long does it take to write and publish an article?",
    answer:
      "Typical turnaround is 5–10 business days. Our process ensures your article is polished, purposeful, and ready for publishing without unnecessary delays.",
  },
];

const ArticalWritingPage = () => {
  return (
    <div>
      <Hero heroData={heroData} />
      <ContactForm />
      <GhostwritingSection ghostData={ghostData} />
      <GhostCta ghostCta={ghostCta} />
      <WhyChooseSection chooseSec={chooseSec} />
      <GhostwritingWorkflow ghostWorkflow={ghostWorkflow} />
      <PortfolioSection
        titleDark="Our"
        titleHighlight="Portfolio"
        para="Our portfolio blends storytelling and design, curated works that
                reflect originality, quality, and genre spanning creativity."
      />
      <FAQSection faqs={faqs} />
    </div>
  );
};

export default ArticalWritingPage;
