import GhostCta from "@/components/GhostwritingPage/Cta/GhostCta";
import FAQSection from "@/components/GhostwritingPage/FAQSection/FAQSection";
import GhostwritingSection from "@/components/GhostwritingPage/GhostwritingSec/GhostwritingSec";
import GhostwritingWorkflow from "@/components/GhostwritingPage/GhostwritingWorkflow/GhostwritingWorkflow";
import Hero from "@/components/GhostwritingPage/HeroSec/Hero";
import WhyChooseSection from "@/components/GhostwritingPage/WhyChooseSec/WhyChooseSec";
import ContactForm from "@/components/landingPage/ContactForm/ContactForm";
import PortfolioSection from "@/components/landingPage/PortfolioSec/PortfolioSec";
import Image from "next/image";

export const metadata = {
  title: "Marketing Authors | Author Promotion & Branding",
  description:
    "Professional marketing for authors. Build your brand, grow your reader base, and get discovered with custom digital marketing services.",
};

const heroData = {
  heading1: (
    <h1 className="hero-titles">
      <span className="hero-title-highlight">
        Marketing <span className="black"> Authors with</span> Strategies That
        Build Brands
      </span>
    </h1>
  ),
  para: "Elume specializes in marketing authors through personalized campaigns that grow visibility, followers, and book sales. From email to Facebook marketing for authors, we help you build a lasting presence and loyal reader base.",
};

const ghostData = {
  heading1: (
    <>
      <h1 className="ghostwriting-title-black">What Is</h1>
      <h1 className="ghostwriting-title-orange"> Author Marketing?</h1>
    </>
  ),
  para1:
    "Author marketing is the process of promoting the author, not just the book. It includes building an online presence, connecting with readers, and increasing long-term book sales. Our marketing for authors service covers personal branding, content planning, audience growth, and platform-specific strategies.",
  para2:
    "Whether you’re looking for digital marketing services for authors or book marketing for self-published authors, Elume delivers tools and tactics that strengthen your brand and boost your reach.",
  image: (
    <Image
      src="/author1.webp"
      alt="Ghostwriting illustration"
      width={694}
      height={553}
      className="ghostwriting-image"
    />
  ),
};

const ghostCta = {
  heading1: (
    <h1 className="hero-main-title">
      You Wrote the Book <br />
      <span className="text-orange">Now Let’s</span>{" "}
      <span className="text-orange">Market You.</span>
    </h1>
  ),
  image: (
    <Image
      src="/author2.webp"
      alt="Ghost writing promotional banner"
      width={1600}
      height={437}
      className="hero-background-image"
    />
  ),
};

const chooseSec = {
  features: (
    <ul>
      <li>We focus on marketing authors, not just titles. </li>
      <li> Great for indie and debut writers</li>
      <li> Builds long-term visibility and reader trust</li>
      <li> Expert in book marketing for self-published authors</li>
      <li>Targeted Facebook marketing for authors</li>
      <li> Let’s grow your author brand together.</li>
    </ul>
  ),

  heading1: <h2 className="why-choose-title">Why Choose Elume Publishers?</h2>,
  image: (
    <Image
      src="/author3.webp"
      width={785}
      height={664}
      alt="Book cover showcase"
      className="book-main"
    />
  ),
};

const ghostWorkflow = {
  mainHeading: (
    <h1 className="workflow-title">
      How Our <span className="text-orange">Author Marketing </span> Process
      Work?
    </h1>
  ),
  mainPara:
    "Our author marketing process builds your brand, grows your audience, and increases book sales through personalized strategies, targeted campaigns, and expert support designed specifically for promoting and marketing authors online.",

  heading1: <h3 className="step-title orange">Build Your Author Brand</h3>,
  para1:
    "We start by defining your niche, tone, and reader persona. From logos and taglines to bios and email welcome sequences, our marketing authors service helps you build a strong and memorable author platform from the ground up.",

  heading2: <h3 className="step-title gray">Plan and Launch Campaigns</h3>,
  para2:
    "Next, we create multi-platform campaigns tailored to your audience. Whether it's newsletters, blog content, or Facebook marketing for authors, we help you attract and engage readers with a mix of organic and paid promotion strategies.",

  heading3: <h3 className="step-title orange">Grow and Optimize</h3>,
  para3:
    "We track engagement, refine messaging, and expand your reach using real-time data. Our digital marketing services for authors evolve with your goals turning casual readers into loyal fans and your name into a brand.",
};

const faqs = [
  {
    question: "What does author marketing include?",
    answer:
      "Our marketing for authors includes branding, social media, email, ads, content strategy, and reader engagement helping you stand out and stay connected with your target audience.",
  },
  {
    question: "Is this service just for self-published authors?",
    answer:
      "No! We help all writers but our book marketing for self-published authors is especially popular, offering affordable, flexible plans to promote your author brand without needing a traditional publisher.",
  },
  {
    question: "Do you offer Facebook marketing for authors?",
    answer:
      "Yes. Our Facebook marketing for authors includes ad creation, audience targeting, and performance tracking designed to help you grow your reader base and drive book sales.",
  },
  {
    question: "What are digital marketing services for authors?",
    answer:
      "Our digital marketing services for authors include email campaigns, SEO, paid ads, social media growth, and platform setup all aimed at building your digital footprint and reaching the right readers.",
  },
  {
    question: "How long before I see results?",
    answer:
      "Most authors begin seeing engagement within 2–4 weeks. Elume’s marketing authors approach is designed for both quick wins and long-term audience growth.",
  },
];

const AuthorMarketingPage = () => {
  return (
    <div>
      <Hero heroData={heroData} />
      <ContactForm />
      <GhostwritingSection ghostData={ghostData} />
      <GhostCta ghostCta={ghostCta} />
      <WhyChooseSection chooseSec={chooseSec} />
      <GhostwritingWorkflow ghostWorkflow={ghostWorkflow} />
      <PortfolioSection
        titleDark="Our"
        titleHighlight="Portfolio"
        para="Our portfolio blends storytelling and design, curated works that
                reflect originality, quality, and genre spanning creativity."
      />
      <FAQSection faqs={faqs} />
    </div>
  );
};

export default AuthorMarketingPage;
