import GhostCta from "@/components/GhostwritingPage/Cta/GhostCta";
import FAQSection from "@/components/GhostwritingPage/FAQSection/FAQSection";
import GhostwritingSection from "@/components/GhostwritingPage/GhostwritingSec/GhostwritingSec";
import GhostwritingWorkflow from "@/components/GhostwritingPage/GhostwritingWorkflow/GhostwritingWorkflow";
import Hero from "@/components/GhostwritingPage/HeroSec/Hero";
import WhyChooseSection from "@/components/GhostwritingPage/WhyChooseSec/WhyChooseSec";
import ContactForm from "@/components/landingPage/ContactForm/ContactForm";
import PortfolioSection from "@/components/landingPage/PortfolioSec/PortfolioSec";
import Image from "next/image";

export const metadata = {
  title: "Author Website Design Services | Custom Author Sites",
  description:
    "Build your online presence with our author website design services. Affordable, mobile-friendly, and tailored for authors of every genre.",
};

const heroData = {
  heading1: (
    <h1 className="hero-titles">
      <span className="hero-title-highlight">
        Author <span className="black">Website Design Services</span> That Build
        Brands
      </span>
    </h1>
  ),
  para: "Our expert author website design services help writers build beautiful, functional sites that showcase books, grow email lists, and boost visibility. From children’s authors to novelists, we design with your audience in mind.",
};

const ghostData = {
  heading1: (
    <>
      <h1 className="ghostwriting-title-black">What Is</h1>
      <h1 className="ghostwriting-title-orange">Author Website?</h1>
    </>
  ),
  para1:
    "Author website design is the process of creating a custom, professional site that reflects your brand, promotes your books, and connects with readers. A good site builds credibility, helps with SEO, and makes book marketing easier.",
  para2:
    "Elume offers affordable author website designers who specialize in working with writers including children’s author website design and eCommerce setup. Need help fast? Our website designers for authors contact process is quick and easy.",
  image: (
    <Image
      src="/web1.webp"
      alt="Ghostwriting illustration"
      width={694}
      height={553}
      className="ghostwriting-image"
    />
  ),
};

const ghostCta = {
  heading1: (
    <h1 className="hero-main-title">
      You Write the Words <br />
      <span className="text-orange">We’ll Build</span> the Website.
    </h1>
  ),
  image: (
    <Image
      src="/web2.webp"
      alt="Ghost writing promotional banner"
      width={1600}
      height={437}
      className="hero-background-image"
    />
  ),
};

const chooseSec = {
  features: (
    <ul>
      <li>We design sites that work for authors.</li>
      <li>Mobile-friendly, SEO-ready pages</li>
      <li>Easy-to-update layouts with full support</li>
      <li>Ideal for children’s authors, self-publishers & bloggers</li>
      <li>Quick setup via website designers for authors contact</li>
      <li>Let’s build your author brand online.</li>
    </ul>
  ),

  heading1: <h2 className="why-choose-title">Why Choose Elume Publishers?</h2>,
  image: (
    <Image
      src="/web3.webp"
      width={785}
      height={664}
      alt="Book cover showcase"
      className="book-main"
    />
  ),
};

const ghostWorkflow = {
  mainHeading: (
    <h1 className="workflow-title">
      How Does Our <span className="text-orange">Author Website Design</span>{" "}
      Process Work?
    </h1>
  ),
  mainPara:
    "Our author website design process blends branding, layout, and usability creating a custom, mobile-friendly site that showcases your books, builds your presence, and connects you with readers effortlessly.",

  heading1: <h3 className="step-title orange">Discover Your Brand & Goals</h3>,
  para1:
    "We start by understanding your brand, genre, audience, and goals. Whether you need children’s author website design or a portfolio for multiple titles, our team plans your structure, features, and visual style to match your author identity.",

  heading2: <h3 className="step-title gray">Design & Develop Your Site</h3>,
  para2:
    "Our author website design services include layout creation, content integration, eCommerce (optional), and blog setup. You’ll review a custom mockup before we move into full development, with revisions to ensure it feels authentic and easy to navigate.",

  heading3: <h3 className="step-title orange"> Launch & Support</h3>,
  para3:
    "Once approved, we launch your site and provide optional training or ongoing updates. Whether you’re a debut or bestselling writer, our affordable author website designers help you build a strong digital presence that grows with you.",
};

const faqs = [
  {
    question: "What’s included in your author website design services?",
    answer:
      "Our author website design services include custom design, mobile optimization, blog setup, contact forms, book pages, mailing list integration, and optional store or blog features.",
  },
  {
    question: "Can you build sites for children’s authors?",
    answer:
      "Yes! We specialize in children’s author website design, with playful visuals, parent-friendly layouts, and book showcases designed to appeal to both kids and adults.",
  },
  {
    question: "How do I contact your website designers for authors?",
    answer:
      "Use our easy website designers for authors contact form or book a free consultation. We’ll guide you through planning, pricing, and design that fits your goals and style.",
  },
  {
    question: "Are your services affordable for indie authors?",
    answer:
      "Absolutely. Our affordable author website designers offer flexible packages based on your needs whether you're just starting out or growing your author brand.",
  },
  {
    question: "Do you provide ongoing support after launch?",
    answer:
      "Yes! We offer optional support plans and quick updates, so your site stays current even if you’re too busy writing to manage the backend.",
  },
];

const AuthorWebPage = () => {
  return (
    <div>
      <Hero heroData={heroData} />
      <ContactForm />
      <GhostwritingSection ghostData={ghostData} />
      <GhostCta ghostCta={ghostCta} />
      <WhyChooseSection chooseSec={chooseSec} />
      <GhostwritingWorkflow ghostWorkflow={ghostWorkflow} />
      <PortfolioSection
        titleDark="Our"
        titleHighlight="Portfolio"
        para="Our portfolio blends storytelling and design, curated works that
                reflect originality, quality, and genre spanning creativity."
      />
      <FAQSection faqs={faqs} />
    </div>
  );
};

export default AuthorWebPage;
