import GhostCta from "@/components/GhostwritingPage/Cta/GhostCta";
import FAQSection from "@/components/GhostwritingPage/FAQSection/FAQSection";
import GhostwritingSection from "@/components/GhostwritingPage/GhostwritingSec/GhostwritingSec";
import GhostwritingWorkflow from "@/components/GhostwritingPage/GhostwritingWorkflow/GhostwritingWorkflow";
import Hero from "@/components/GhostwritingPage/HeroSec/Hero";
import WhyChooseSection from "@/components/GhostwritingPage/WhyChooseSec/WhyChooseSec";
import ContactForm from "@/components/landingPage/ContactForm/ContactForm";
import PortfolioSection from "@/components/landingPage/PortfolioSec/PortfolioSec";
import Image from "next/image";

export const metadata = {
  title: "Blog Writing Service | Ghost Blog Writing Experts",
  description:
    "Engaging, SEO-optimized blog writing service. We plan, write, and deliver blogs that drive traffic. Ghost blog writing available.",
};

const heroData = {
  heading1: (
    <h1 className="hero-titles">
      <span className="hero-title-highlight">
        <span className="black">Blog Writing Service</span> That Builds Your
        Brand
      </span>
    </h1>
  ),
  para: "With our professional blog writing service, you get well-researched, SEO-optimized posts designed to engage readers and grow traffic. Whether you're writing blogs to inform, inspire, or sell we write them for results.",
};

const ghostData = {
  heading1: (
    <>
      <h1 className="ghostwriting-title-black">What Is</h1>
      <h1 className="ghostwriting-title-orange">Blog Writing?</h1>
    </>
  ),
  para1:
    "Blog writing is the process of creating consistent, valuable, and relevant content to attract and engage your target audience. From how-to guides to thought leadership, blogging drives traffic, builds authority, and supports SEO.",
  para2:
    "Our blog article writing service covers strategy, writing, formatting, and delivery. We also offer ghost blog writing, so you get expertly written posts under your name without spending hours creating them yourself.",
  image: (
    <Image
      src="/pub1.webp"
      alt="Ghostwriting illustration"
      width={694}
      height={553}
      className="ghostwriting-image"
    />
  ),
};

const ghostCta = {
  heading1: (
    <h1 className="hero-main-title">
      Your Ideas, Our Expertise <br />
      <span className="text-orange">Let's Create</span> Blogs{" "}
      <span className="text-orange">That Work.</span>
    </h1>
  ),
  image: (
    <Image
      src="/blog2.webp"
      alt="Ghost writing promotional banner"
      width={1600}
      height={437}
      className="hero-background-image"
    />
  ),
};

const chooseSec = {
  features: (
    <ul>
      <li>We write blogs that rank, read, and resonate.</li>
      <li>SEO-optimized content for any niche</li>
      <li>Tone and voice tailored to your brand</li>
      <li> Flexible plans one-time or monthly</li>
      <li> Trusted blog article writing service</li>
      <li> Let’s grow your voice online.</li>
    </ul>
  ),

  heading1: <h2 className="why-choose-title">Why Choose Elume Publishers?</h2>,
  image: (
    <Image
      src="/bookleft.webp"
      width={785}
      height={664}
      alt="Book cover showcase"
      className="book-main"
    />
  ),
};

const ghostWorkflow = {
  mainHeading: (
    <h1 className="workflow-title">
      How Our <span className="text-orange">Blog Writing</span> Process Work?
    </h1>
  ),
  mainPara:
    "Our blog writing process turns your ideas into high-quality, SEO-optimized content from strategy and research to writing, editing, and delivery, we handle everything to keep your blog consistent and results-driven.",

  heading1: <h3 className="step-title orange">Content Planning</h3>,
  para1:
    "We begin with your niche, target audience, and goals. Whether you want educational posts or product-driven content, our blog writing service builds a content calendar that aligns with your brand, voice, and marketing strategy.",

  heading2: <h3 className="step-title gray">Research, Write & Optimize</h3>,
  para2:
    "Each post is researched and written with your keywords, tone, and readers in mind. Our ghost blog writing ensures clean, engaging content delivered under your name fully optimized for readability, search engines, and conversions.",

  heading3: <h3 className="step-title orange">Edit, Format & Deliver </h3>,
  para3:
    "We proofread, format, and deliver each post ready to publish including headings, meta descriptions, and internal linking if needed. Whether one blog or a full content plan, our blog article writing service handles everything for you.",
};

const faqs = [
  {
    question: "What’s included in your blog writing service?",
    answer:
      "Our blog writing service includes topic planning, research, writing, editing, SEO optimization, and formatting all tailored to your brand and publishing goals.",
  },
  {
    question: "Do you offer ghost blog writing?",
    answer:
      "Yes! Our ghost blog writing allows us to write blogs under your name or brand professionally written, fully optimized, and delivered ready to publish.",
  },
  {
    question: "What industries do you write for?",
    answer:
      "We write for nearly all industries from creative to corporate. Our blog article writing service adapts to your niche, tone, and content strategy.",
  },
  {
    question: "How often should I post blogs?",
    answer:
      "We recommend posting weekly or biweekly for best SEO results. Our team can manage your blog schedule and keep content consistent.",
  },
  {
    question: "Can you write blog posts optimized for SEO?",
    answer:
      "Absolutely. We specialize in SEO-optimized blog writing, including proper formatting, keywords, metadata, and internal linking for better search engine visibility.",
  },
];

const GhostwritingPage = () => {
  return (
    <div>
      <Hero heroData={heroData} />
      <ContactForm />
      <GhostwritingSection ghostData={ghostData} />
      <GhostCta ghostCta={ghostCta} />
      <WhyChooseSection chooseSec={chooseSec} />
      <GhostwritingWorkflow ghostWorkflow={ghostWorkflow} />
      <PortfolioSection
        titleDark="Our"
        titleHighlight="Portfolio"
        para="Our portfolio blends storytelling and design, curated works that
                reflect originality, quality, and genre spanning creativity."
      />
      <FAQSection faqs={faqs} />
    </div>
  );
};

export default GhostwritingPage;
