import GhostCta from "@/components/GhostwritingPage/Cta/GhostCta";
import FAQSection from "@/components/GhostwritingPage/FAQSection/FAQSection";
import GhostwritingSection from "@/components/GhostwritingPage/GhostwritingSec/GhostwritingSec";
import GhostwritingWorkflow from "@/components/GhostwritingPage/GhostwritingWorkflow/GhostwritingWorkflow";
import Hero from "@/components/GhostwritingPage/HeroSec/Hero";
import WhyChooseSection from "@/components/GhostwritingPage/WhyChooseSec/WhyChooseSec";
import ContactForm from "@/components/landingPage/ContactForm/ContactForm";
import PortfolioSection from "@/components/landingPage/PortfolioSec/PortfolioSec";
import Image from "next/image";

export const metadata = {
  title: "Affordable eBook Cover Design for Authors",
  description:
    "Custom, affordable ebook cover design services for authors, including children’s books. Make your book stand out on every shelf.",
};

const heroData = {
  heading1: (
    <h1 className="hero-titles">
      <span className="hero-title-highlight">
        Affordable <span className="black"> eBook Cover Design</span> That Sells
        Books
      </span>
    </h1>
  ),
  para: "Make your first impression count with our affordable eBook cover design service. Elume Publishers creates custom, genre-appropriate covers that grab attention and convert browsers into buyers for authors of every genre and audience.",
};

const ghostData = {
  heading1: (
    <>
      <h1 className="ghostwriting-title-black">What Is</h1>
      <h1 className="ghostwriting-title-orange">eBook Cover Design?</h1>
    </>
  ),
  para1:
    "eBook cover design is the visual gateway to your story it grabs attention, sets tone, and drives sales. At Elume, we blend creativity with market insight to design covers that connect with readers.",
  para2:
    "Whether it’s children’s book cover design or bold genre fiction, we customize every visual detail. Our ebook cover design services deliver scroll-stopping, professional covers for platforms like Amazon, Kobo, Apple Books, and more.",
  image: (
    <Image
      src="/cover1.webp"
      alt="Ghostwriting illustration"
      width={694}
      height={553}
      className="ghostwriting-image"
    />
  ),
};

const ghostCta = {
  heading1: (
    <h1 className="hero-main-title">
      Your Story, Visually Captured <br />
      <span className="text-orange">Let's Design</span> a Cover{" "}
      <span className="text-orange">That Sells.</span>
    </h1>
  ),
  image: (
    <Image
      src="/cover2.webp"
      alt="Ghost writing promotional banner"
      width={1600}
      height={437}
      className="hero-background-image"
    />
  ),
};

const chooseSec = {
  features: (
    <ul>
      <li>We turn your vision into a standout cover.</li>
      <li> Genre-specific designs that sell</li>
      <li> Ideal for self-published authors</li>
      <li>Trusted for children’s book cover design</li>
      <li> Full ebook cover design services</li>
      <li> Let’s design a cover your readers can’t ignore.</li>
    </ul>
  ),

  heading1: <h2 className="why-choose-title">Why Choose Elume Publishers?</h2>,
  image: (
    <Image
      src="/cover3.webp"
      width={785}
      height={664}
      alt="Book cover showcase"
      className="book-main"
    />
  ),
};

const ghostWorkflow = {
  mainHeading: (
    <h1 className="workflow-title">
      How Our <span className="text-orange"> Book Cover Design</span> Process
      Work?
    </h1>
  ),
  mainPara:
    "Our book cover design process turns your ideas into eye-catching visuals from concept and draft to final delivery, we create professional, platform-ready covers that attract readers and reflect your story.",

  heading1: <h3 className="step-title orange">Share Your Vision</h3>,
  para1:
    "Tell us about your book, audience, and genre. Our designers use this input to brainstorm creative concepts. Whether you need a sleek thriller cover or children’s book cover design, we start with your story and style in mind.",

  heading2: <h3 className="step-title gray">Draft, Design & Feedback</h3>,
  para2:
    "We present initial cover drafts tailored to your market. You give feedback, we revise. Our affordable eBook cover design process is fully collaborative ensuring you love the final version and that it resonates with your readers.",

  heading3: (
    <h3 className="step-title orange">Final Delivery in All Formats</h3>
  ),
  para3:
    "After approval, we deliver high-resolution files for Amazon, Kindle, and other platforms. Our ebook cover design services include ready-to-upload files that meet each platform’s specs ensuring your book is not only beautiful but compliant.",
};

const faqs = [
  {
    question: "What does your eBook cover design service include?",
    answer:
      "Our ebook cover design services include concept development, professional design, revisions, and final delivery in all sizes and formats for Amazon KDP, Apple Books, Kobo, and more.",
  },
  {
    question: "Do you offer children’s book cover design?",
    answer:
      "Yes! We create playful, colorful, and age-appropriate children’s book cover designs that appeal to both young readers and parents always aligned with your book’s theme and tone.",
  },
  {
    question: "How much does eBook cover design cost?",
    answer:
      "We offer affordable eBook cover design packages to fit various budgets. You get professional quality, custom artwork, and fast turnaround without the high-end agency price tag.",
  },
  {
    question: "Can I request changes during the design process?",
    answer:
      "Absolutely! Our design process is collaborative. We include revisions so you can refine layout, fonts, or visuals ensuring you get a cover that fits your vision and sells well.",
  },
  {
    question: "Do you provide files for all publishing platforms?",
    answer:
      "Yes. We deliver files in platform-specific dimensions and formats. Our ebook cover design services ensure your cover is ready to upload to Amazon, Smashwords, Apple Books, and more.",
  },
];

const BookCoverPage = () => {
  return (
    <div>
      <Hero heroData={heroData} />
      <ContactForm />
      <GhostwritingSection ghostData={ghostData} />
      <GhostCta ghostCta={ghostCta} />
      <WhyChooseSection chooseSec={chooseSec} />
      <GhostwritingWorkflow ghostWorkflow={ghostWorkflow} />
      <PortfolioSection
        titleDark="Our"
        titleHighlight="Portfolio"
        para="Our portfolio blends storytelling and design, curated works that
                reflect originality, quality, and genre spanning creativity."
      />
      <FAQSection faqs={faqs} />
    </div>
  );
};

export default BookCoverPage;
