import GhostCta from "@/components/GhostwritingPage/Cta/GhostCta";
import FAQSection from "@/components/GhostwritingPage/FAQSection/FAQSection";
import GhostwritingSection from "@/components/GhostwritingPage/GhostwritingSec/GhostwritingSec";
import GhostwritingWorkflow from "@/components/GhostwritingPage/GhostwritingWorkflow/GhostwritingWorkflow";
import Hero from "@/components/GhostwritingPage/HeroSec/Hero";
import WhyChooseSection from "@/components/GhostwritingPage/WhyChooseSec/WhyChooseSec";
import ContactForm from "@/components/landingPage/ContactForm/ContactForm";
import PortfolioSection from "@/components/landingPage/PortfolioSec/PortfolioSec";
import Image from "next/image";

export const metadata = {
  title: "Print a Book | Affordable Book Printing Services",
  description:
    "Print your book with professional quality. Hardcover, paperback, and children’s book printing at affordable prices straight from PDF to press.",
};

const heroData = {
  heading1: (
    <h1 className="hero-titles">
      <span className="hero-title-highlight">
        Print <span className="black">a Book That</span> Looks and Sells
      </span>
    </h1>
  ),
  para: "Want to print a book professionally? Elume Publishers offers premium, affordable book printing services for authors of all genres. From paperbacks to hardcover book printing, we bring your finished manuscript to life in print.",
};

const ghostData = {
  heading1: (
    <>
      <h1 className="ghostwriting-title-black">What Is</h1>
      <h1 className="ghostwriting-title-orange">Book Printing?</h1>
    </>
  ),
  para1:
    "Book printing is the process of transforming your digital manuscript into a professionally bound, physical product. Whether you’re looking for children’s book printing, hardcover book printing, or paperback runs, we help you choose the right format, trim size, and finish.",
  para2:
    " You can even print your own book from PDF. Elume ensures your final product matches industry standards and makes your book bookstore- and reader-ready.",
  image: (
    <Image
      src="/print1.webp"
      alt="Ghostwriting illustration"
      width={694}
      height={553}
      className="ghostwriting-image"
    />
  ),
};

const ghostCta = {
  heading1: (
    <h1 className="hero-main-title">
      You Wrote the Words <br />
      <span className="text-orange">We’ll Bring</span> Them to{" "}
      <span className="text-orange">Life in Print.</span>
    </h1>
  ),
  image: (
    <Image
      src="/print2.webp"
      alt="Ghost writing promotional banner"
      width={1600}
      height={437}
      className="hero-background-image"
    />
  ),
};

const chooseSec = {
  features: (
    <ul>
      <li>We make book printing simple, fast, and professional.</li>
      <li>Print-on-demand and bulk options</li>
      <li>Premium quality at affordable book printing prices</li>
      <li>Color, trim, and paper customization</li>
      <li>Specialized in children’s book printing and hardcovers</li>
      <li> Let’s turn your file into a shelf-ready book.</li>
    </ul>
  ),

  heading1: <h2 className="why-choose-title">Why Choose Elume Publishers?</h2>,
  image: (
    <Image
      src="/print3.webp"
      width={785}
      height={664}
      alt="Book cover showcase"
      className="book-main"
    />
  ),
};

const ghostWorkflow = {
  mainHeading: (
    <h1 className="workflow-title">
      How Our <span className="text-orange">Book Printing</span> Process Work?
    </h1>
  ),
  mainPara:
    "Our book printing process transforms your manuscript into a high-quality, professionally bound book with file setup, format selection, and fast delivery tailored for paperbacks, hardcovers, or children’s books of any genre.",

  heading1: <h3 className="step-title orange">Send Your File</h3>,
  para1:
    "Upload your formatted manuscript or print your own book from PDF. We check layout, trim size, and print specs. Whether it's for retail, school use, or events, we prep everything to meet your goals.",

  heading2: <h3 className="step-title gray">Choose Your Print Style</h3>,
  para2:
    "Pick between paperback, hardcover book printing, or custom options. Choose page finish, binding type, and quantity. We offer full-color options, bleed settings, and layout support especially useful for children’s book printing or illustrated titles.",

  heading3: <h3 className="step-title orange">Print & Deliver</h3>,
  para3:
    "Once approved, we print your book and ship to your doorstep or distributor. With affordable book printing options and global delivery, your story goes from file to finished book ready to sell, gift, or stock.",
};

const faqs = [
  {
    question: " How do I print a book with Elume?",
    answer:
      "Simply send your file, choose your format, and we’ll handle the rest. We help you print a book that looks professional and meets industry standards.",
  },
  {
    question: "Do you offer affordable book printing options?",
    answer:
      "Yes! We provide affordable book printing for short runs and bulk orders, with custom trim sizes, paper types, and binding to fit your budget and quality expectations.",
  },
  {
    question: "Can I print children’s books with illustrations?",
    answer:
      "Absolutely. We specialize in children’s book printing with vibrant color, durable paper, and custom sizing to bring illustrated and picture books to life.",
  },
  {
    question: "Do you offer hardcover book printing?",
    answer:
      "Yes! Our hardcover book printing includes durable bindings, cloth or gloss finishes, dust jackets, and foil stamping perfect for memoirs, keepsakes, or premium editions.",
  },
  {
    question: "Can I print my own book from a PDF?",
    answer:
      "Yes! You can print your own book from PDF. Just upload the file, and we’ll format and prep it for high-quality printing exactly how you envision it.",
  },
];

const BookPrintingPage = () => {
  return (
    <div>
      <Hero heroData={heroData} />
      <ContactForm />
      <GhostwritingSection ghostData={ghostData} />
      <GhostCta ghostCta={ghostCta} />
      <WhyChooseSection chooseSec={chooseSec} />
      <GhostwritingWorkflow ghostWorkflow={ghostWorkflow} />
      <PortfolioSection
        titleDark="Our"
        titleHighlight="Portfolio"
        para="Our portfolio blends storytelling and design, curated works that
                reflect originality, quality, and genre spanning creativity."
      />
      <FAQSection faqs={faqs} />
    </div>
  );
};

export default BookPrintingPage;
