import GhostCta from "@/components/GhostwritingPage/Cta/GhostCta";
import FAQSection from "@/components/GhostwritingPage/FAQSection/FAQSection";
import GhostwritingSection from "@/components/GhostwritingPage/GhostwritingSec/GhostwritingSec";
import GhostwritingWorkflow from "@/components/GhostwritingPage/GhostwritingWorkflow/GhostwritingWorkflow";
import Hero from "@/components/GhostwritingPage/HeroSec/Hero";
import WhyChooseSection from "@/components/GhostwritingPage/WhyChooseSec/WhyChooseSec";
import ContactForm from "@/components/landingPage/ContactForm/ContactForm";
import PortfolioSection from "@/components/landingPage/PortfolioSec/PortfolioSec";
import Image from "next/image";

export const metadata = {
  title: "Books Getting Published | Trusted Book Publishers USA",
  description:
    " Get your books published with Elume’s expert support. Trusted book publishers for first-time authors & special editions in New York.",
};

const heroData = {
  heading1: (
    <h1 className="hero-titles">
      <span className="hero-title-highlight">
        Your <span className="black">Journey to Books</span> to Bring Your
        Getting Published Begins
      </span>
    </h1>
  ),
  para: "Looking to get your book published? Elume Publishers helps turn your manuscript into a professionally published book. We make books getting published easy, accessible, and rewarding especially for new voices ready to be heard.",
};

const ghostData = {
  heading1: (
    <>
      <h1 className="ghostwriting-title-black">What Is</h1>
      <h1 className="ghostwriting-title-orange">Book Publishing?</h1>
    </>
  ),
  para1:
    "Book publishing is the process of transforming your written manuscript into a finished product printed or digital ready for readers. At Elume Publishers, we handle editing, design, ISBN registration, and distribution.",
  para2:
    "As one of the trusted book publishing companies in New York, we support new and experienced authors alike. Whether you're self-publishing or seeking special edition book publishers, we make your publishing journey smooth, professional, and successful.",
  image: (
    <Image
      src="/pub1.webp"
      alt="Ghostwriting illustration"
      width={694}
      height={553}
      className="ghostwriting-image"
    />
  ),
};

const ghostCta = {
  heading1: (
    <h1 className="hero-main-title">
      Your Story, Our Platform <br />
      <span className="text-orang">Let's Publish</span> Your{" "}
      <span className="text-orang">Legacy Together.</span>
    </h1>
  ),
  image: (
    <Image
      src="/bookpub2.webp"
      alt="Ghost writing promotional banner"
      width={1600}
      height={437}
      className="hero-background-image"
    />
  ),
};

const chooseSec = {
  features: (
    <ul>
      <li>
        We’re not just publishers we’re partners in your literary journey.
      </li>
      <li>Ideal for first-time authors.</li>
      <li>Clear, transparent publishing process.</li>
      <li>High-quality design, editing, and printing.</li>
      <li>Trusted among book publishing companies in New York.</li>
      <li> Let’s publish your story the right way.</li>
      {/* <li>Your story, told perfectly.</li> */}
    </ul>
  ),

  heading1: <h2 className="why-choose-title">Why Choose Elume Publishers?</h2>,
  image: (
    <Image
      src="/bookleft.webp"
      width={785}
      height={664}
      alt="Book cover showcase"
      className="book-main"
    />
  ),
};

const ghostWorkflow = {
  mainHeading: (
    <h1 className="workflow-title">
      How Our <span className="text-orange">Book Publishing Process</span> Work?
    </h1>
  ),
  mainPara:
    "Our streamlined process makes books getting published simple from manuscript review and professional editing to final printing and distribution, we guide you every step to bring your story into the world.",

  heading1: <h3 className="step-title orange">Submit Your Manuscript</h3>,
  para1:
    "Your journey to books getting published begins when you share your manuscript with our team. We review your content, genre, and goals, then recommend the best publishing approach tailored to your vision from formatting to distribution planning, we start with strategy and care.",

  heading2: <h3 className="step-title gray">We Prepare Your Book </h3>,
  para2:
    "Our team handles editing, layout, and cover design while you stay informed throughout. As experienced book publishers for first time authors, we make sure your book meets industry standards and feels professionally crafted all while preserving your original voice and vision.",

  heading3: <h3 className="step-title orange">Publish and Distribute</h3>,
  para3:
    "Once everything is polished, we publish your book in print and/or digital format. Whether you’re aiming for Amazon, bookstores, or a limited collector’s release with special edition book publishers, we ensure your story is beautifully produced and ready to reach readers worldwide.",
};

const faqs = [
  {
    question: "How do I get my book published for the first time?",
    answer:
      "Start by submitting your manuscript. Elume Publishers supports first-time authors with editing, design, and distribution to make books getting published a smooth and rewarding process.",
  },
  {
    question: "How much does it cost to publish a book in the USA?",
    answer:
      "Publishing costs vary, but Elume Publishers offers affordable packages to help you get your book published professionally, whether you’re printing or going digital.",
  },
  {
    question: "What are the best book publishing companies in New York?",
    answer:
      "Top book publishing companies in New York offer transparency and quality. Elume Publishers stands out by helping authors publish high-quality books with full support and industry expertise.",
  },
  {
    question: "Can I publish a special edition of my book?",
    answer:
      "Yes! As special edition book publishers, we help authors create premium, limited-edition releases with custom covers, finishes, and packaging to make your book truly unique and collectible.",
  },
  {
    question: "Do I keep the rights after publishing my book?",
    answer:
      "Absolutely. You retain full ownership and creative control. At Elume, books getting published means your name on the cover and all rights stay with you.",
  },
];

const BookPublishingPage = () => {
  return (
    <div>
      <Hero heroData={heroData} />
      <ContactForm />
      <GhostwritingSection ghostData={ghostData} />
      <GhostCta ghostCta={ghostCta} />
      <WhyChooseSection chooseSec={chooseSec} />
      <GhostwritingWorkflow ghostWorkflow={ghostWorkflow} />
      <PortfolioSection
        titleDark="Our"
        titleHighlight="Portfolio"
        para="Our portfolio blends storytelling and design, curated works that
                reflect originality, quality, and genre spanning creativity."
      />
      <FAQSection faqs={faqs} />
    </div>
  );
};

export default BookPublishingPage;
