import GhostCta from "@/components/GhostwritingPage/Cta/GhostCta";
import FAQSection from "@/components/GhostwritingPage/FAQSection/FAQSection";
import GhostwritingSection from "@/components/GhostwritingPage/GhostwritingSec/GhostwritingSec";
import GhostwritingWorkflow from "@/components/GhostwritingPage/GhostwritingWorkflow/GhostwritingWorkflow";
import Hero from "@/components/GhostwritingPage/HeroSec/Hero";
import WhyChooseSection from "@/components/GhostwritingPage/WhyChooseSec/WhyChooseSec";
import ContactForm from "@/components/landingPage/ContactForm/ContactForm";
import PortfolioSection from "@/components/landingPage/PortfolioSec/PortfolioSec";
import Image from "next/image";

export const metadata = {
  title: "Business Proposal Writing Services That Win Deals",
  description:
    "We write winning proposals and grant pitches for small businesses. Clear, persuasive, and professional documents tailored to your goals.",
};

const heroData = {
  heading1: (
    <h1 className="hero-titles">
      <span className="hero-title-highlight">
        Business <span className="black">Proposal Writing Services</span> That
        Win Deals
      </span>
    </h1>
  ),
  para: "Elume offers professional business proposal writing services that help you secure funding, partnerships, and clients. Whether you're writing a business proposal or pitching a grant, we turn your ideas into persuasive, winning proposals.",
};

const ghostData = {
  heading1: (
    <>
      <h1 className="ghostwriting-title-black">What Is</h1>
      <h1 className="ghostwriting-title-orange">Proposal Writing?</h1>
    </>
  ),
  para1:
    "Business proposal writing involves creating persuasive, structured documents that communicate your value, ideas, or solutions to clients, investors, or grant committees.",
  para2:
    "Whether it’s a sales pitch, writing a grant proposal for small business, or formal proposal writing for businesses, our team ensures your message is strategic and impactful. Elume specializes in crafting proposals that are clear, data-backed, and professionally presented giving your business the edge it needs to succeed.",
  image: (
    <Image
      src="/proposal1.webp"
      alt="Ghostwriting illustration"
      width={694}
      height={553}
      className="ghostwriting-image"
    />
  ),
};

const ghostCta = {
  heading1: (
    <h1 className="hero-main-title">
      You Pitch the Idea <br />
      <span className="text-orange">We Write</span> the Proposal{" "}
      <span className="text-orange">That Secures It.</span>
    </h1>
  ),
  image: (
    <Image
      src="/proposal2.webp"
      alt="Ghost writing promotional banner"
      width={1600}
      height={437}
      className="hero-background-image"
    />
  ),
};

const chooseSec = {
  features: (
    <ul>
      <li>We write proposals that win attention and action.</li>
      <li> Clear, customized proposals tailored to your goals</li>
      <li>Grant, business, and partnership proposals</li>
      <li> Fast turnaround with full support</li>
      <li>Trusted for proposal writing for businesses</li>
      <li> Let’s secure your next “yes.”</li>
    </ul>
  ),

  heading1: <h2 className="why-choose-title">Why Choose Elume Publishers?</h2>,
  image: (
    <Image
      src="/proposal3.webp"
      width={785}
      height={664}
      alt="Book cover showcase"
      className="book-main"
    />
  ),
};

const ghostWorkflow = {
  mainHeading: (
    <h1 className="workflow-title">
      How Does Our{" "}
      <span className="text-orange">Business Proposal Writing</span> Process
      Work?
    </h1>
  ),
  mainPara:
    "Our business proposal writing process turns your ideas into professionally written, goal-focused proposals with tailored messaging, structured formatting, and expert refinement designed to win clients, funding, or partnership opportunities.",

  heading1: (
    <h3 className="step-title orange">Understand Your Offer & Audience</h3>
  ),
  para1:
    "We start by learning about your business, offer, and target audience. Whether you're writing a business proposal for a client or investor, we align your message with what decision-makers want to hear and how they want to see it.",

  heading2: <h3 className="step-title gray">Write, Edit & Refine</h3>,
  para2:
    "Our experts create a persuasive, structured proposal with compelling messaging, proper formatting, and clear benefits. We handle content creation and revisions whether it's a partnership pitch or writing a grant proposal for small business.",

  heading3: <h3 className="step-title orange">Finalize & Deliver</h3>,
  para3:
    "We finalize the design and formatting, ensuring your proposal is polished and professional. Your business proposal writing services package includes editable files, PDF delivery, and optional visuals to help you stand out and close the deal confidently.",
};

const faqs = [
  {
    question: "What’s included in your business proposal writing services?",
    answer:
      "We offer end-to-end business proposal writing services, including consultation, writing, formatting, editing, and delivery ideal for clients, investors, or grant submissions.",
  },
  {
    question: "Can you help with writing a grant proposal for small business?",
    answer:
      "Yes! We specialize in writing a grant proposal for small business, with experience in funding goals, requirements, and positioning your story to attract approval.",
  },
  {
    question: "How long does it take to write a proposal?",
    answer:
      "Depending on complexity, we typically deliver in 5–7 business days. Rush options are available for urgent projects.",
  },
  {
    question: "Can you format and design the proposal too?",
    answer:
      "Absolutely. Along with content, we offer design and layout to ensure your proposal writing for businesses looks as professional as it reads.",
  },
  {
    question: " What industries do you write proposals for?",
    answer:
      "We serve startups, nonprofits, consultants, and product-based businesses. Our business proposal writing services adapt to your goals and industry standards.",
  },
];

const GhostwritingPage = () => {
  return (
    <div>
      <Hero heroData={heroData} />
      <ContactForm />
      <GhostwritingSection ghostData={ghostData} />
      <GhostCta ghostCta={ghostCta} />
      <WhyChooseSection chooseSec={chooseSec} />
      <GhostwritingWorkflow ghostWorkflow={ghostWorkflow} />
      <PortfolioSection
        titleDark="Our"
        titleHighlight="Portfolio"
        para="Our portfolio blends storytelling and design, curated works that
                reflect originality, quality, and genre spanning creativity."
      />
      <FAQSection faqs={faqs} />
    </div>
  );
};

export default GhostwritingPage;
