import GhostCta from "@/components/GhostwritingPage/Cta/GhostCta";
import FAQSection from "@/components/GhostwritingPage/FAQSection/FAQSection";
import GhostwritingSection from "@/components/GhostwritingPage/GhostwritingSec/GhostwritingSec";
import GhostwritingWorkflow from "@/components/GhostwritingPage/GhostwritingWorkflow/GhostwritingWorkflow";
import Hero from "@/components/GhostwritingPage/HeroSec/Hero";
import WhyChooseSection from "@/components/GhostwritingPage/WhyChooseSec/WhyChooseSec";
import ContactForm from "@/components/landingPage/ContactForm/ContactForm";
import PortfolioSection from "@/components/landingPage/PortfolioSec/PortfolioSec";
import Image from "next/image";

export const metadata = {
  title: "Book Illustration Services | Affordable Kids Illustrators",
  description:
    "Professional book illustration services for children’s books. Hire affordable illustrators to bring your story to life with vibrant visuals.",
};

const heroData = {
  heading1: (
    <h1 className="hero-titles">
      <span className="hero-title-highlight">
        Book <span className="black"> Illustration Services</span> That Bring
        Stories Alive
      </span>
    </h1>
  ),
  para: "Our professional book illustration services turn your words into vivid, child-friendly visuals. From concept sketches to full-color spreads, Elume helps authors illustrate children’s books that capture young imaginations and complement every page perfectly.",
};

const ghostData = {
  heading1: (
    <>
      <h1 className="ghostwriting-title-black">What Is</h1>
      <h1 className="ghostwriting-title-orange">Book Illustration?</h1>
    </>
  ),
  para1:
    "Illustration is key to a child’s reading experience. Illustrating children’s books involves more than drawing it's about creating artwork that supports storytelling, tone, and age-appropriate engagement.",
  para2:
    "At Elume, our book illustration services include character design, layout planning, and full-scene illustrations. Whether you need one spread or a full picture book, we help authors hire a children’s book illustrator who brings your unique story to visual life.",
  image: (
    <Image
      src="/illustration1.webp"
      alt="Ghostwriting illustration"
      width={694}
      height={553}
      className="ghostwriting-image"
    />
  ),
};

const ghostCta = {
  heading1: (
    <h1 className="hero-main-title">
      You Imagine It <br />
      <span className="text-orange">Let’s Make</span> Your{" "}
      <span className="text-orange">Story Unforgettable.</span>
    </h1>
  ),
  image: (
    <Image
      src="/illustration2.webp"
      alt="Ghost writing promotional banner"
      width={1600}
      height={437}
      className="hero-background-image"
    />
  ),
};

const chooseSec = {
  features: (
    <ul>
      <li>We pair great stories with great visuals.</li>
      <li>Collaborative process with input at every stage</li>
      <li>Experienced in various children’s styles and genres</li>
      <li>Trusted by indie authors and publishers</li>
      <li>Home to affordable children’s book illustrators</li>
      <li> Let your story shine in color.</li>
    </ul>
  ),

  heading1: <h2 className="why-choose-title">Why Choose Elume Publishers?</h2>,
  image: (
    <Image
      src="/illustration3.webp"
      width={785}
      height={664}
      alt="Book cover showcase"
      className="book-main"
    />
  ),
};

const ghostWorkflow = {
  mainHeading: (
    <h1 className="workflow-title">
      How Our <span className="text-orange">Children’s Book Illustration </span>{" "}
      Process Work?
    </h1>
  ),
  mainPara:
    "Our illustration process brings your children’s story to life from concept sketches to final artwork, we deliver vibrant, age-appropriate visuals that perfectly match your story’s tone, theme, and characters.",

  heading1: <h3 className="step-title orange">Visual Discovery</h3>,
  para1:
    "We start by understanding your story, characters, and vision. Whether you’re still outlining or ready for final art, our book illustration services begin with creative planning tailored to your book’s tone, age group, and visual style preferences.",

  heading2: <h3 className="step-title gray">Sketches & Concepts</h3>,
  para2:
    "You’ll review initial sketches and character designs before full-page illustrations begin. Whether you want whimsical, bold, or realistic styles, we help you hire a children’s book illustrator who captures your story’s heart with every detail.",

  heading3: <h3 className="step-title orange">Final Artwork & Delivery</h3>,
  para3:
    "Once approved, we deliver high-resolution artwork in print and digital formats. Our affordable children’s book illustrators ensure each image aligns with your layout ready for publication, marketing, or submission to agents and publishers.",
};

const faqs = [
  {
    question: "What do your book illustration services include?",
    answer:
      "Our book illustration services include character design, full-page spreads, cover art, and layout-ready files customized to your book’s age group, tone, and publishing platform.",
  },
  {
    question: " How do I hire a children’s book illustrator?",
    answer:
      "Through Elume, you can hire a children’s book illustrator easily. We match you with the right artist based on your style preferences, genre, and budget and manage the full process.",
  },
  {
    question: "Can you help with illustrating children's books from scratch?",
    answer:
      "Yes! Whether you're starting with an idea or a full manuscript, we specialize in illustrating children’s books from concept to completion including design layout and final delivery.",
  },
  {
    question: "How much do children’s book illustrations cost?",
    answer:
      "We offer affordable children’s book illustrators with flexible pricing based on page count, complexity, and style. You’ll get professional artwork without exceeding your publishing budget.",
  },
  {
    question: "Will my illustrations be print-ready?",
    answer:
      "Absolutely. We deliver high-resolution, print-ready files in the correct sizes and formats ideal for both print and digital publishing.",
  },
];

const BookIllustrationPage = () => {
  return (
    <div>
      <Hero heroData={heroData} />
      <ContactForm />
      <GhostwritingSection ghostData={ghostData} />
      <GhostCta ghostCta={ghostCta} />
      <WhyChooseSection chooseSec={chooseSec} />
      <GhostwritingWorkflow ghostWorkflow={ghostWorkflow} />
      <PortfolioSection
        titleDark="Our"
        titleHighlight="Portfolio"
        para="Our portfolio blends storytelling and design, curated works that
                reflect originality, quality, and genre spanning creativity."
      />
      <FAQSection faqs={faqs} />
    </div>
  );
};

export default BookIllustrationPage;
