import GhostCta from "@/components/GhostwritingPage/Cta/GhostCta";
import FAQSection from "@/components/GhostwritingPage/FAQSection/FAQSection";
import GhostwritingSection from "@/components/GhostwritingPage/GhostwritingSec/GhostwritingSec";
import GhostwritingWorkflow from "@/components/GhostwritingPage/GhostwritingWorkflow/GhostwritingWorkflow";
import Hero from "@/components/GhostwritingPage/HeroSec/Hero";
import WhyChooseSection from "@/components/GhostwritingPage/WhyChooseSec/WhyChooseSec";
import ContactForm from "@/components/landingPage/ContactForm/ContactForm";
import PortfolioSection from "@/components/landingPage/PortfolioSec/PortfolioSec";
import Image from "next/image";

export const metadata = {
  title: "Children’s Writing Books | Creative Kids Book Writers",
  description:
    "Specialized children’s writing books services. We create fun, engaging, and age-appropriate stories for young readers in every genre.",
};

const heroData = {
  heading1: (
    <h1 className="hero-titles">
      <span className="hero-title-highlight">
        Children’s <span className="black"> Writing Books</span> That Inspire
        Young Minds
      </span>
    </h1>
  ),
  para: "At Elume, we bring your stories to life through expert children’s writing books services. From idea to final draft, we help authors craft magical, age-appropriate tales that captivate kids and satisfy publishing standards.",
};

const ghostData = {
  heading1: (
    <>
      <h1 className="ghostwriting-title-black">What Is</h1>
      <h1 className="ghostwriting-title-orange">Children’s Book?</h1>
    </>
  ),
  para1:
    "Children book writing involves more than telling a story it’s about choosing the right tone, vocabulary, and themes for each age group. Whether you're writing a children's book for early readers or middle-grade kids, it requires clarity, rhythm, and imagination.",
  para2:
    "Elume’s team understands the nuances of children’s book writing format and helps shape stories that are fun, educational, and emotionally engaging for both children and their parents.",
  image: (
    <Image
      src="/children1.webp"
      alt="Ghostwriting illustration"
      width={694}
      height={553}
      className="ghostwriting-image"
    />
  ),
};

const ghostCta = {
  heading1: (
    <h1 className="hero-main-title">
      Your Imagination, Our Words <br />
      <span className="text-orange">Let's Create</span> a Story{" "}
      <span className="text-orange">Kids Will Love.</span>
    </h1>
  ),
  image: (
    <Image
      src="/children2.webp"
      alt="Ghost writing promotional banner"
      width={1600}
      height={437}
      className="hero-background-image"
    />
  ),
};

const chooseSec = {
  features: (
    <ul>
      <li>We specialize in children’s writing books that make a difference.</li>
      <li>Tailored to specific age groups</li>
      <li>Educational, fun, and meaningful</li>
      <li> Experienced in rhyme, dialogue, and pacing</li>
      <li> Experts in children’s book writing format</li>
      <li> We help your story shine.</li>
    </ul>
  ),

  heading1: <h2 className="why-choose-title">Why Choose Elume Publishers?</h2>,
  image: (
    <Image
      src="/children3.webp"
      width={785}
      height={664}
      alt="Book cover showcase"
      className="book-main"
    />
  ),
};

const ghostWorkflow = {
  mainHeading: (
    <h1 className="workflow-title">
      How Our <span className="text-orange">Children’s Book Writing</span>{" "}
      Process Work?
    </h1>
  ),
  mainPara:
    "Our children’s book writing process turns your ideas into magical, age-appropriate stories with thoughtful planning, creative writing, and expert formatting that brings your vision to life for young readers and publishers alike.",

  heading1: <h3 className="step-title orange">Story Planning & Structure</h3>,
  para1:
    "We begin by understanding your vision, audience, and message. Whether you have a full outline or just a spark of an idea, we help build the framework for a compelling and age-appropriate story for your children’s writing book.",

  heading2: <h3 className="step-title gray">Writing the Manuscript</h3>,
  para2:
    "Our writers bring your story to life with engaging language, relatable characters, and proper tone for the chosen age group. From picture books to chapter books, our children book writing ensures your manuscript is creative, clear, and ready to captivate.",

  heading3: <h3 className="step-title orange">Editing and Formatting</h3>,
  para3:
    "We revise and polish your manuscript while applying proper children’s book writing format including layout guidance for illustrators. The final product is clean, structured, and ready for illustration, editing, and submission to publishers or self-publishing platforms.",
};

const faqs = [
  {
    question: "What age groups do you write for?",
    answer:
      "We write for all age ranges from toddlers to middle-grade readers. Our children book writing adapts tone, structure, and vocabulary to suit your audience perfectly.",
  },
  {
    question: "Can you help me with writing a children’s book?",
    answer:
      "Absolutely! Whether you’re starting from scratch or editing a draft, we guide you through every step of writing a children’s book from concept to completed manuscript.",
  },
  // {
  //   question: "Do I retain the rights to my book if I publish through Elume Publishers?",
  //   answer: "Yes, as a self-publishing service provider, Elume Publishers ensures that authors retain full rights to their books. You have complete ownership over your manuscript and published content."
  // },
  {
    question: "What is the correct children’s book writing format?",
    answer:
      "Children’s book writing format varies by age and publisher. We follow industry standards for layout, word count, pacing, and page breaks making your manuscript submission- or print-ready.",
  },
  {
    question: "Do you include illustrations in the service?",
    answer:
      "We specialize in writing, but we can recommend professional illustrators or collaborate with your chosen artist to ensure your story and visuals align perfectly.",
  },
  {
    question: " How long does it take to write a children’s book?",
    answer:
      "Depending on length and complexity, most projects take 2–6 weeks. Our process ensures your children’s writing book is delivered efficiently without compromising creativity or quality.",
  },
];

const ChildernBookPage = () => {
  return (
    <div>
      <Hero heroData={heroData} />
      <ContactForm />
      <GhostwritingSection ghostData={ghostData} />
      <GhostCta ghostCta={ghostCta} />
      <WhyChooseSection chooseSec={chooseSec} />
      <GhostwritingWorkflow ghostWorkflow={ghostWorkflow} />
      <PortfolioSection
        titleDark="Our"
        titleHighlight="Portfolio"
        para="Our portfolio blends storytelling and design, curated works that
                reflect originality, quality, and genre spanning creativity."
      />
      <FAQSection faqs={faqs} />
    </div>
  );
};

export default ChildernBookPage;
