import Link from "next/link";

export const metadata = {
  title: "Terms & Conditions | Elume Publishers",
  description:
    "Review the terms and conditions for using Elume Publishers’ website and services. Stay informed about your rights, responsibilities, and legal policies.",
};

const TermsAndCondition = () => {
  return (
    <>
      <section className="privacy-page">
        <div className="container">
          <div className="row">
            <div className="col-lg-12">
              <div className="privacy-content">
                <h1>Terms of Use</h1>
                <p className="para">
                  {" "}
                  Welcome to the Elume Publishers LLC website located at{" "}
                  <Link href={"/"}>https://elumepublishers.com</Link> (ELUME
                  PUBLISHERS). These Terms of Use govern your use of our Site
                  and services. By accessing or using our Site, you agree to be
                  bound by these Terms and our Privacy Policy.
                </p>

                <div className="privacy-content-box">
                  <h3>1. Use of Site</h3>
                  <p className="para">
                    You may use this Site for lawful purposes only. You agree
                    not to:
                  </p>
                  <ul>
                    <li>
                      Use the Site in any way that violates applicable federal,
                      state, or local laws.
                    </li>
                    <li>
                      Engage in any conduct that restricts or inhibits any other
                      user from using the Site.
                    </li>
                    <li>
                      Attempt to gain unauthorized access to any portion of the
                      Site.
                    </li>
                    <li>Use automated scripts or bots to access the Site.</li>
                  </ul>
                </div>
                <div className="privacy-content-box">
                  <h3>2. Intellectual Property</h3>
                  <p className="para">
                    All content on this Site, including text, images, logos,
                    graphics, and software, is the property of Elume Publishers
                    or its licensors and is protected by intellectual property
                    laws. You may not copy, reproduce, modify, distribute, or
                    display any part of the Site without our prior written
                    consent.
                  </p>
                </div>
                <div className="privacy-content-box">
                  <h3>3. User Submissions</h3>
                  <p className="para">
                    If you submit materials such as manuscripts, inquiries, or
                    other content through our Site:
                  </p>
                  <ul>
                    <li>
                      You represent that you own or have the necessary rights to
                      submit the content.
                    </li>
                    <li>
                      You grant Elume Publishers a non-exclusive, royalty-free
                      license to use, reproduce, and modify such content as
                      needed to provide services.
                    </li>
                    <li>
                      You agree not to submit unlawful, defamatory, or
                      infringing content.
                    </li>
                  </ul>
                </div>
                <div className="privacy-content-box">
                  <h3>4. Disclaimers</h3>
                  <p className="para">
                    The Site and all content are provided "as is" without
                    warranties of any kind. We do not guarantee that the Site
                    will be error-free, uninterrupted, or free of viruses. We
                    make no warranties or representations regarding the
                    accuracy, reliability, or completeness of content or
                    services. The Site and all content are provided "as is"
                    without warranties of any kind. We do not guarantee that the
                    Site will be error-free, uninterrupted, or free of viruses.
                    We make no warranties or representations regarding the
                    accuracy, reliability, or completeness of content or
                    services.
                  </p>
                </div>
                <div className="privacy-content-box">
                  <h3>5. Limitation of Liability</h3>
                  <p className="para">
                    To the fullest extent permitted by law, Elume Publishers
                    shall not be liable for any direct, indirect, incidental, or
                    consequential damages arising from your use of the Site or
                    reliance on any content or services provided herein.
                  </p>
                </div>
                <div className="privacy-content-box">
                  <h3>6. Third-Party Links</h3>
                  <p className="para">
                    Our Site may contain links to third-party websites for
                    convenience. These links do not constitute an endorsement,
                    and we are not responsible for the content or practices of
                    those websites.
                  </p>
                </div>
                <div className="privacy-content-box">
                  <h3>7. Termination</h3>
                  <p className="para">
                    We reserve the right to terminate or suspend your access to
                    the Site at any time, without notice, for conduct that we
                    believe violates these Terms or is otherwise harmful to
                    other users or to us.
                  </p>
                </div>
                <div className="privacy-content-box">
                  <h3>8. Changes to Terms</h3>
                  <p className="para">
                    Elume Publishers reserves the right to update these Terms at
                    any time. Any changes will be posted on this page with a
                    revised effective date. Continued use of the Site after
                    changes constitutes acceptance of the new Terms.
                  </p>
                </div>
                <div className="privacy-content-box">
                  <h3>9. Governing Law</h3>
                  <p className="para">
                    These Terms shall be governed by and construed in accordance
                    with the laws of the State of Illinois, without regard to
                    its conflict of law principles.
                  </p>
                </div>
                <div className="privacy-content-box">
                  <h3>10. Contact Us</h3>
                  <p className="para">
                    If you have any questions about these Terms, please contact
                    us at:
                  </p>
                  <p className="para">Elume Publishers</p>
                  <p className="para">119 S Western Ave Unit 1 #238</p>
                  <p className="para">Chicago, IL 60612</p>
                  <p className="para">
                    Email:{" "}
                    <Link href={"mailto:info@elumepublishers.com"}>
                      info@elumepublishers.com
                    </Link>
                  </p>
                  <p className="para">
                    Phone: <Link href="tel:12179069606">+1 (217) 906 9606</Link>
                  </p>
                </div>
              </div>
            </div>
          </div>
        </div>
      </section>
    </>
  );
};

export default TermsAndCondition;
