import GhostCta from "@/components/GhostwritingPage/Cta/GhostCta";
import FAQSection from "@/components/GhostwritingPage/FAQSection/FAQSection";
import GhostwritingSection from "@/components/GhostwritingPage/GhostwritingSec/GhostwritingSec";
import GhostwritingWorkflow from "@/components/GhostwritingPage/GhostwritingWorkflow/GhostwritingWorkflow";
import Hero from "@/components/GhostwritingPage/HeroSec/Hero";
import WhyChooseSection from "@/components/GhostwritingPage/WhyChooseSec/WhyChooseSec";
import ContactForm from "@/components/landingPage/ContactForm/ContactForm";
import PortfolioSection from "@/components/landingPage/PortfolioSec/PortfolioSec";
import Image from "next/image";

export const metadata = {
  title: "Legal Translation Services | Translate eBooks & More",
  description:
    "Certified legal translation services for authors and businesses. Translate ebooks and documents with expert accuracy from English to Spanish and more.",
};

const heroData = {
  heading1: (
    <h1 className="hero-titles">
      <span className="hero-title-highlight">
        Legal <span className="black">Translation Services</span> That Read
        Naturally Everywhere
      </span>
    </h1>
  ),
  para: "Elume offers expert legal translation services and multilingual publishing support for authors and businesses. Whether you need to translate an ebook or documents from English to Spanish, we ensure clarity, accuracy, and fluency.",
};

const ghostData = {
  heading1: (
    <>
      <h1 className="ghostwriting-title-black">What Is</h1>
      <h1 className="ghostwriting-title-orange">Translation Services?</h1>
    </>
  ),
  para1:
    "Translation services convert written content from one language to another, preserving tone, accuracy, and intent. At Elume, our certified legal translation services handle contracts, manuscripts, and formal documents with care.",
  para2:
    " We also specialize in helping authors translate ebooks for global audiences, including English to Spanish translation services. Whether you're publishing internationally or localizing business materials, we make your words work across cultures and borders.",
  image: (
    <Image
      src="/trans1.webp"
      alt="Ghostwriting illustration"
      width={694}
      height={553}
      className="ghostwriting-image"
    />
  ),
};

const ghostCta = {
  heading1: (
    <h1 className="hero-main-title">
      From Manuscript to Multilingual <br />
      <span className="text-orange">Let’s Make</span> Your{" "}
      <span className="text-orange">Story Travel.</span>
    </h1>
  ),
  image: (
    <Image
      src="/trans2.webp"
      alt="Ghost writing promotional banner"
      width={1600}
      height={437}
      className="hero-background-image"
    />
  ),
};

const chooseSec = {
  features: (
    <ul>
      <li>We go beyond literal translation.</li>
      <li>Human translators, not AI tools</li>
      <li>Legal, literary, and publishing expertise</li>
      <li>Fast turnaround with confidentiality</li>
      <li>Trusted for English to Spanish translation services</li>
      <li> Let’s make your message clear in any language.</li>
    </ul>
  ),

  heading1: <h2 className="why-choose-title">Why Choose Elume Publishers?</h2>,
  image: (
    <Image
      src="/trans3.webp"
      width={785}
      height={664}
      alt="Book cover showcase"
      className="book-main"
    />
  ),
};

const ghostWorkflow = {
  mainHeading: (
    <h1 className="workflow-title">
      How Our <span className="text-orange">Translation Process</span> Work?
    </h1>
  ),
  mainPara:
    "Our translation process ensures accurate, culturally adapted results from initial review and native-language translation to expert proofreading, so your legal documents or ebooks read flawlessly in any language.",

  heading1: <h3 className="step-title orange">Submit Your Text & Goals</h3>,
  para1:
    "We begin with your source material and target language. Whether you're requesting legal translation services or want to translate an ebook, we review the content for tone, context, and purpose to match it accurately in the new language.",

  heading2: <h3 className="step-title gray">Assign a Native Translator </h3>,
  para2:
    "We match your project with a certified, native-language translator. For English to Spanish translation services, this ensures cultural accuracy, smooth flow, and context-aware word choices especially important for legal or long-form content like ebooks and contracts.",

  heading3: <h3 className="step-title orange">Review, Proof, and Deliver</h3>,
  para3:
    "Each translation is proofread, formatted, and reviewed by a second linguist for clarity and correctness. From legal clauses to chapter titles, our legal translation services ensure your content is ready for publishing, submission, or distribution worldwide.",
};

const faqs = [
  {
    question: "What types of content do you translate?",
    answer:
      "We handle everything from contracts and documents to translate ebooks, author bios, and websites ensuring tone, accuracy, and professionalism in every language.",
  },
  {
    question: "Do you provide English to Spanish translation services?",
    answer:
      "Yes! Our English to Spanish translation services are handled by native-speaking professionals with expertise in legal, literary, and commercial content ideal for authors and businesses alike.",
  },
  {
    question: "Are your legal translations certified?",
    answer:
      "Absolutely. Our legal translation services are handled by certified professionals, ensuring compliance, accuracy, and acceptance for official use when required.",
  },
  {
    question: "How long does it take to translate an ebook?",
    answer:
      "Time depends on word count and language pair. A standard ebook takes 7–14 business days. We offer expedited delivery on request.",
  },
  {
    question: "Do you use AI or human translators?",
    answer:
      "We only use human translators no automated tools. Every translation is culturally adapted, proofread, and reviewed for total quality.",
  },
];

const TranslationPage = () => {
  return (
    <div>
      <Hero heroData={heroData} />
      <ContactForm />
      <GhostwritingSection ghostData={ghostData} />
      <GhostCta ghostCta={ghostCta} />
      <WhyChooseSection chooseSec={chooseSec} />
      <GhostwritingWorkflow ghostWorkflow={ghostWorkflow} />
      <PortfolioSection
        titleDark="Our"
        titleHighlight="Portfolio"
        para="Our portfolio blends storytelling and design, curated works that
                reflect originality, quality, and genre spanning creativity."
      />
      <FAQSection faqs={faqs} />
    </div>
  );
};

export default TranslationPage;
