import GhostCta from "@/components/GhostwritingPage/Cta/GhostCta";
import FAQSection from "@/components/GhostwritingPage/FAQSection/FAQSection";
import GhostwritingSection from "@/components/GhostwritingPage/GhostwritingSec/GhostwritingSec";
import GhostwritingWorkflow from "@/components/GhostwritingPage/GhostwritingWorkflow/GhostwritingWorkflow";
import Hero from "@/components/GhostwritingPage/HeroSec/Hero";
import WhyChooseSection from "@/components/GhostwritingPage/WhyChooseSec/WhyChooseSec";
import ContactForm from "@/components/landingPage/ContactForm/ContactForm";
import PortfolioSection from "@/components/landingPage/PortfolioSec/PortfolioSec";
import Image from "next/image";

export const metadata = {
  title: " Website Content Writing | SEO Content That Converts",
  description:
    "Get expert website content writing for your business. Optimized, engaging copy that helps your site rank and convert visitors.",
};

const heroData = {
  heading1: (
    <h1 className="hero-titles">
      <span className="hero-title-highlight">
        Website <span className="black">Content Writing</span> That Converts and
        Ranks
      </span>
    </h1>
  ),
  para: "Our expert website content writing services help you connect, convert, and climb the search rankings. Elume creates clear, compelling copy optimized for your audience and aligned with Google SEO writing content for websites.",
};

const ghostData = {
  heading1: (
    <>
      <h1 className="ghostwriting-title-black">What Is</h1>
      <h1 className="ghostwriting-title-orange">Content Writing?</h1>
    </>
  ),
  para1:
    "Website content writing is the creation of clear, engaging, and goal-driven text for your site from homepages and service pages to landing pages and bios.",
  para2:
    "At Elume, we focus on content writing for a website that not only sounds good but performs well. As a best website content writing service, we balance user intent with SEO strategy to build trust, improve engagement, and drive measurable results.",
  image: (
    <Image
      src="/content1.webp"
      alt="Ghostwriting illustration"
      width={694}
      height={553}
      className="ghostwriting-image"
    />
  ),
};

const ghostCta = {
  heading1: (
    <h1 className="hero-main-title">
      Turn Clicks Into Customers <br />
      <span className="text-orange">With </span> Website Content{" "}
      <span className="text-orange">That Works.</span>
    </h1>
  ),
  image: (
    <Image
      src="/content2.webp"
      alt="Ghost writing promotional banner"
      width={1600}
      height={437}
      className="hero-background-image"
    />
  ),
};

const chooseSec = {
  features: (
    <ul>
      <li>We write words that work for your brand.</li>
      <li>Clear messaging and brand tone</li>
      <li>SEO-optimized for better rankings</li>
      <li>Ideal for small businesses, startups, and authors</li>
      <li>Trusted best website content writing service</li>
      <li>Let’s turn your visitors into customers.</li>
    </ul>
  ),

  heading1: <h2 className="why-choose-title">Why Choose Elume Publishers?</h2>,
  image: (
    <Image
      src="/content3.webp"
      width={785}
      height={664}
      alt="Book cover showcase"
      className="book-main"
    />
  ),
};

const ghostWorkflow = {
  mainHeading: (
    <h1 className="workflow-title">
      How Our <span className="text-orange">Website Content Writing</span>{" "}
      Process Work?
    </h1>
  ),
  mainPara:
    "Our website content writing process blends strategy, SEO, and brand voice delivering clear, engaging copy that informs, converts, and ranks across every page of your site.",

  heading1: <h3 className="step-title orange"> Learn Your Brand & Goals</h3>,
  para1:
    "We begin with a discovery session to understand your business, audience, and voice. Whether it’s a full site rewrite or updates, our website content writing service ensures your message is consistent, relevant, and strategically positioned.",

  heading2: <h3 className="step-title gray">Write SEO-Optimized Content</h3>,
  para2:
    "Using your keywords and voice, we write engaging, easy-to-read content that meets both user needs and Google standards. Our Google SEO writing content for website ensures visibility without sacrificing authenticity or clarity.",

  heading3: <h3 className="step-title orange">Edit, Refine & Deliver </h3>,
  para3:
    "We polish every word for grammar, tone, and structure then format and deliver ready-to-upload content. Whether you're building a new site or refreshing an old one, our best website content writing service gets you ready to launch.",
};

const faqs = [
  {
    question: "What’s included in your website content writing service?",
    answer:
      "Our website content writing includes brand research, SEO strategy, copywriting, editing, and formatting all tailored to your business and online goals.",
  },
  {
    question: "How is this different from regular content writing?",
    answer:
      "Content writing for a website focuses on user experience, brand voice, and search engine performance combining persuasive writing with structure optimized for conversions and rankings.",
  },
  {
    question: "Can you write for my entire website?",
    answer:
      "Yes! Whether it’s five pages or fifty, our best website content writing service delivers consistent, on-brand, and optimized copy for every section of your site.",
  },
  {
    question: "Do you follow SEO best practices?",
    answer:
      "Absolutely. Our Google SEO writing content for website includes keyword integration, readability improvements, metadata optimization, and content structure aligned with search intent and ranking guidelines.",
  },
  {
    question: "What industries do you serve?",
    answer:
      "We serve authors, startups, coaches, and businesses across various industries. Our flexible website content writing approach adapts to your tone, audience, and niche.",
  },
];

const WebContentPage = () => {
  return (
    <div>
      <Hero heroData={heroData} />
      <ContactForm />
      <GhostwritingSection ghostData={ghostData} />
      <GhostCta ghostCta={ghostCta} />
      <WhyChooseSection chooseSec={chooseSec} />
      <GhostwritingWorkflow ghostWorkflow={ghostWorkflow} />
      <PortfolioSection
        titleDark="Our"
        titleHighlight="Portfolio"
        para="Our portfolio blends storytelling and design, curated works that
                reflect originality, quality, and genre spanning creativity."
      />
      <FAQSection faqs={faqs} />
    </div>
  );
};

export default WebContentPage;
