import React from "react";
import "./ChooseUs.css";
import Image from "next/image";

const ChooseUs = () => {
  return (
    <section className="choose-banner">
      <div className="container">
        <div className="row">
          <div className="col-lg-12">
            {/* Header Section */}
            <div className="text-center mb-5">
              <h1 className="choose-title">Why Choose Elume Publishers?</h1>
              <p className="choose-description">
                Elume Publishers treats every project as a unique creative
                expertise. Professional writers and authors with expertise and a
                deep understanding of what makes stories succeed. You’re a
                brand, and we’re here to help you make a lasting mark in the
                literary world.
              </p>
            </div>

            {/* Books Image Section */}
            <div className="books-display">
              <div className="books-wrapper">
                <Image
                  src="/cta.webp"
                  alt="Books showcase"
                  width={1200}
                  height={460}
                  className="books-main-image"
                />
              </div>

              {/* Orange Glow Effect */}
              <div className="orange-glow"></div>
            </div>
          </div>
        </div>
      </div>
    </section>
  );
};

export default ChooseUs;
