"use client";
import React from "react";
import "./Hero.css";

function Hero() {
  const handleSearch = (e) => {
    e.preventDefault();
  };

  return (
    <section className="hero-search-section position-relative d-flex align-items-center">
      <div className="hero-bg-pattern"></div>

      <div className="container position-relative">
        <div className="row justify-content-center">
          <div className="col-12">
            <header className="text-center mb-4">
              <h1 className="hero-main-heading mb-3">
                Fueling Growth through
                <br />
                <span className="heading-dark">Innovation & Creativity</span>
              </h1>
              <p className="hero-description mx-auto">
                Stay in touch with the latest industry trends, market insights,
                <br className="d-none d-md-block" />
                and news shaping the world of tomorrow.
              </p>
            </header>

            <div className="search-wrapper mx-auto">
              <div className="search-form d-flex align-items-center justify-content-between">
                <input
                  type="search"
                  placeholder="Search"
                  className="search-input flex-grow-1"
                />
                <button
                  onClick={handleSearch}
                  className="search-btn d-flex align-items-center justify-content-center"
                >
                  <svg
                    width="23"
                    height="23"
                    viewBox="0 0 23 23"
                    fill="none"
                    xmlns="http://www.w3.org/2000/svg"
                    className="search-icon"
                  >
                    <path
                      d="M10 18C14.4183 18 18 14.4183 18 10C18 5.58172 14.4183 2 10 2C5.58172 2 2 5.58172 2 10C2 14.4183 5.58172 18 10 18Z"
                      stroke="white"
                      strokeWidth="2"
                      strokeLinecap="round"
                      strokeLinejoin="round"
                    />
                    <path
                      d="M21 21L16 16"
                      stroke="white"
                      strokeWidth="2"
                      strokeLinecap="round"
                      strokeLinejoin="round"
                    />
                  </svg>
                </button>
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
  );
}

export default Hero;
