"use client";
import React, { useEffect, useState } from "react";
import "./HeroSec.css";

const Hero = () => {
  const [isTawkReady, setIsTawkReady] = useState(false);

  useEffect(() => {
    const checkTawk = setInterval(() => {
      if (window.Tawk_API && window.Tawk_API.popup) {
        setIsTawkReady(true);
        clearInterval(checkTawk);
      }
    }, 500);

    return () => clearInterval(checkTawk);
  }, []);

  const openChat = () => {
    if (window.Tawk_API) {
      window.Tawk_API.maximize();
    } else {
      alert("Chat not ready yet!");
    }
  };

  return (
    <section className="hero-story">
      <div className="hero-bg-patterns"></div>

      <div className="container">
        <div className="row align-items-center justify-content-center">
          <div className="col-12">
            <div>
              <h1 className="hero-headings">Across All Genres</h1>
              <h3 className="hero-subHeadings">
                Professional Ghostwriting Agency
              </h3>
              <p className="hero-texts">
                We are the professional ghostwriting agency across all genres.
                Our aim is to deliver stories that cherish readers with perfect
                influence at Elume Publishers. Perhaps it’s the thrill of a
                mystery, the warmth of a romance, or the boundless creativity of
                fantasy.
              </p>
            </div>
            <div className="row mt-4 btnside ">
              <div className="col-12 col-md-auto">
                <button
                  className="quote-button"
                  data-bs-toggle="modal"
                  data-bs-target="#couponModal"
                >
                  <div
                    dangerouslySetInnerHTML={{
                      __html:
                        '<svg id="1:188" width="305" height="60" viewBox="0 0 305 60" fill="none" xmlns="http://www.w3.org/2000/svg" class="quote-button" style="display: flex; width: 280px; height: 55px; padding: 0px 10px; align-items: center; gap: 10px; border-radius: 70px; background: linear-gradient(180deg, rgba(201,89,13,1) 0%, rgba(235,152,59,1) 100%); box-shadow: 11px 9px 27px 0 rgba(0,0,0,0.20) inset; position: relative; cursor: pointer"> <g filter="url(#filter0_i_1_188)"> <rect width="105" height="10" rx="30"></rect> <circle opacity="0.2" cx="33" cy="30" r="23" fill="#fff"></circle> <circle opacity="0.3" cx="33" cy="30" r="17" fill="#fff"></circle> <circle opacity="0.3" cx="33" cy="30" r="11" fill="#fff"></circle> <circle cx="33" cy="30" r="5" fill="#fff"></circle> <text fill="#fff" xml:space="preserve" style="white-space: pre" font-family="Montserrat" font-size="22" font-weight="500" letter-spacing="-0.04em"><tspan x="66" y="37.17">Get Your Free Quote</tspan></text> </g> <defs>  <feBlend mode="normal" in="SourceGraphic" in2="BackgroundImageFix" result="shape"></feBlend> <feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"></feColorMatrix> <feOffset dx="11" dy="9"></feOffset> <feGaussianBlur stdDeviation="13.5"></feGaussianBlur> <feComposite in2="hardAlpha" operator="arithmetic" k2="-1" k3="1"></feComposite> <feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.2 0"></feColorMatrix> <feBlend mode="normal" in2="shape" result="effect1_innerShadow_1_188"></feBlend> </filter> </defs> </svg>',
                    }}
                  />
                </button>
              </div>
              <div className="col-12 col-md-auto">
                <button
                  className="chat-button"
                  onClick={openChat}
                  disabled={!isTawkReady}
                >
                  <div
                    dangerouslySetInnerHTML={{
                      __html:
                        '<svg id="1:195" width="305" height="60" viewBox="0 0 305 60" fill="none" xmlns="http://www.w3.org/2000/svg" class="chat-button" style="display: flex; width: 280px; height: 55px; padding: 0px 0px; justify-content: center; align-items: center; gap: 12px; border-radius: 70px; background: linear-gradient(180deg,#008C1E 0%,#2BF055 100%); position: relative; cursor: pointer"> <rect width="305" height="60" rx="30" fill="url(#paint0_linear_1_195)"></rect> <path d="M87.8182 26.8985V26.8182C87.8182 18.9233 81.3949 12.5 73.5 12.5C65.6051 12.5 59.1818 18.9233 59.1818 26.8182V26.8985C57.369 27.2684 56 28.8744 56 30.7955V33.9773C56 36.1703 57.7842 37.9545 59.9773 37.9545H61.5682C62.4456 37.9545 63.1591 37.241 63.1591 36.3636V28.4091C63.1591 27.5317 62.4456 26.8182 61.5682 26.8182H60.7727C60.7727 19.8007 66.4825 14.0909 73.5 14.0909C80.5175 14.0909 86.2273 19.8007 86.2273 26.8182H85.4318C84.5544 26.8182 83.8409 27.5317 83.8409 28.4091V36.3636C83.8409 37.241 84.5544 37.9545 85.4318 37.9545H86.2273C86.2273 41.0242 83.7295 43.5227 80.6591 43.5227H78.9552C78.5997 42.1538 77.3643 41.1364 75.8864 41.1364H73.5C71.7452 41.1364 70.3182 42.5634 70.3182 44.3182C70.3182 46.073 71.7452 47.5 73.5 47.5H75.8864C77.3643 47.5 78.5997 46.4826 78.9552 45.1136H80.6591C84.6061 45.1136 87.8182 41.9024 87.8182 37.9545V37.8742C89.631 37.5043 91 35.8983 91 33.9773V30.7955C91 28.8752 89.631 27.2684 87.8182 26.8985ZM61.5682 28.4091V36.3636H59.9773C58.6616 36.3636 57.5909 35.293 57.5909 33.9773V30.7955C57.5909 29.4798 58.6616 28.4091 59.9773 28.4091H61.5682ZM75.8864 45.9091H73.5C72.6226 45.9091 71.9091 45.1956 71.9091 44.3182C71.9091 43.4408 72.6226 42.7273 73.5 42.7273H75.8864C76.7638 42.7273 77.4773 43.4408 77.4773 44.3182C77.4773 45.1956 76.7638 45.9091 75.8864 45.9091ZM89.4091 33.9773C89.4091 35.293 88.3384 36.3636 87.0227 36.3636H85.4318V28.4091H87.0227C88.3384 28.4091 89.4091 29.4798 89.4091 30.7955V33.9773Z" fill="white"></path> <path d="M71.5621 39.4294L73.8323 37.1592H77.4803C79.6733 37.1592 81.4576 35.375 81.4576 33.1819V28.4092C81.4576 26.2161 79.6733 24.4319 77.4803 24.4319H69.5257C67.3327 24.4319 65.5485 26.2161 65.5485 28.4092V33.1819C65.5485 35.375 67.3327 37.1592 69.5257 37.1592V38.5854C69.5257 39.0698 69.8153 39.5026 70.2631 39.6879C70.4119 39.75 70.567 39.7794 70.7205 39.7794C71.0307 39.7794 71.3338 39.6585 71.5621 39.4294ZM69.5249 35.5682C68.2093 35.5682 67.1386 34.4976 67.1386 33.1819V28.4092C67.1386 27.0935 68.2093 26.0228 69.5249 26.0228H77.4795C78.7952 26.0228 79.8658 27.0935 79.8658 28.4092V33.1819C79.8658 34.4976 78.7952 35.5682 77.4795 35.5682H73.5022C73.2914 35.5682 73.0886 35.6518 72.9398 35.8013L71.1158 37.6253V36.3637C71.1158 35.9238 70.7595 35.5682 70.3204 35.5682H69.5249Z" fill="white"></path> <path d="M70.3173 30.0001H76.6809C77.12 30.0001 77.4764 29.6437 77.4764 29.2046C77.4764 28.7655 77.12 28.4092 76.6809 28.4092H70.3173C69.8782 28.4092 69.5219 28.7655 69.5219 29.2046C69.5219 29.6437 69.8782 30.0001 70.3173 30.0001Z" fill="white"></path> <path d="M75.8855 32.3863C75.8855 31.9464 75.5291 31.5908 75.09 31.5908H70.3173C69.8782 31.5908 69.5219 31.9464 69.5219 32.3863C69.5219 32.8262 69.8782 33.1817 70.3173 33.1817H75.09C75.5291 33.1817 75.8855 32.8262 75.8855 32.3863Z" fill="white"></path> <text fill="white" xml:space="preserve" style="white-space: pre" font-family="Montserrat" font-size="22" font-weight="500" letter-spacing="-0.01em"><tspan x="103" y="37.17">Live Chat Now</tspan></text> <defs> <stop stop-color="#008C1E"></stop> <stop offset="1" stop-color="#2BF055"></stop> </linearGradient> </defs> </svg>',
                    }}
                  />
                </button>
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
  );
};

export default Hero;
