import React from "react";
import "./Hero.css";
import Image from "next/image";

function Hero() {
  return (
    <>
      <section className="hero-testimonials position-relative overflow-hidden">
        <div className="hero-background">
          <Image
            src="https://api.builder.io/api/v1/image/assets/TEMP/6de63bd9bbde7357688b3c207e396eb02b5c892a?width=3840"
            alt="Hero Background"
            fill
            className="hero-bg-image"
          />
        </div>

        <div className="hero-wrapper">
          <div className="container">
            <div className="row justify-content-center align-items-center">
              <div className="col-12 col-lg-12">
                <header className="hero-header text-center mb-4">
                  <h1 className="hero-titles">
                    <span className="hero-title-highlight">
                      What Our Authors
                    </span>
                    <br />
                    <span className="black">Are Saying</span>
                  </h1>
                </header>

                <div className="row justify-content-center">
                  <div className="col-12">
                    <div className="text-center">
                      <p className="hero-texts">
                        Our authors share their experiences with Elume
                        Publishers highlighting creativity, collaboration, and
                        success that reflect our dedication to delivering
                        exceptional publishing services and bringing every story
                        to its full potential.
                      </p>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </section>
    </>
  );
}

export default Hero;
