import React from "react";
import "./Testimonials.css";
import Image from "next/image";
import { FaStar, FaRegStar } from "react-icons/fa";

export const TestimonialCard = ({
  profileImage,
  name,
  title,
  rating,
  testimonial,
}) => {
  return (
    <article className="testimonial-card">
      <div className="testimonial-header">
        <div className="d-flex align-items-center gap-3 flex-grow-1">
          <Image
            src={profileImage}
            className="testimonial-avatar"
            width={300}
            height={200}
            alt={`${name} profile`}
          />
          <div className="testimonial-info">
            <h4 className="testimonial-name">{name}</h4>
            <p className="testimonial-title">{title}</p>
          </div>
        </div>
        <StarRating rating={rating} />
      </div>
      <div className="testimonial-divider"></div>
      <blockquote className="testimonial-text">{testimonial}</blockquote>
    </article>
  );
};

export const HostCard = ({ image, name, title, icon }) => {
  return (
    <article className="host-card">
      <Image
        src={image}
        width={351}
        height={440}
        className="host-card-img"
        alt={`${name} profile`}
      />
      <div className="host-card-content">
        <div className="host-info">
          <h3 className="host-name">{name}</h3>
          <p className="host-title">{title}</p>
        </div>
      </div>
    </article>
  );
};

export const StarRating = ({ rating }) => {
  return (
    <div className="star-rating d-flex gap-1">
      {[...Array(5)].map((_, index) =>
        index < rating ? (
          <FaStar
            key={index}
            className="star-icon"
            style={{ color: "#f5c518", fill: "#f5c518" }}
            size={22}
          />
        ) : (
          <FaRegStar
            key={index}
            className="star-icon"
            style={{ color: "#f5c518", fill: "#f5c518" }}
            size={22}
          />
        )
      )}
    </div>
  );
};

const TestimonialsSection = () => {
  const hosts = [
    {
      image:
        "https://api.builder.io/api/v1/image/assets/15161154b48645df88fb0490ee5cc09b/fe6394ca5b80b5e815f99227fb50296a2e8d3c97?placeholderIfAbsent=true",
      name: "Mark T",
      title: "Host of 'Tech Talks'",
    },
    {
      image:
        "https://api.builder.io/api/v1/image/assets/15161154b48645df88fb0490ee5cc09b/2ac411ccc74e203f15c725fdf9e16b9825677dff?placeholderIfAbsent=true",
      name: "Jessica M",
      title: "Host of 'Voices Unfiltered'",
    },
    {
      image:
        "https://api.builder.io/api/v1/image/assets/15161154b48645df88fb0490ee5cc09b/19a77dc273afb39d34926cc7bd2c8143fb526614?placeholderIfAbsent=true",
      name: "Ryan S",
      title: "Host of 'The Daily Update'",
    },
  ];

  const testimonials = [
    {
      profileImage:
        "https://api.builder.io/api/v1/image/assets/15161154b48645df88fb0490ee5cc09b/4d89f54fd4dacf521565c815d852fb687f22396b?placeholderIfAbsent=true",
      name: "Olivia Rose",
      title: "Author & Entrepreneur",
      testimonial:
        "The editor caught details I completely missed. My book feels more refined and ready for publishing.",
    },
    {
      profileImage:
        "https://api.builder.io/api/v1/image/assets/15161154b48645df88fb0490ee5cc09b/c4857d8a75020d4291f107d4d57739072add1b86?placeholderIfAbsent=true",
      name: "Liam Alexander",
      title: "Business Strategist",
      testimonial:
        "The voice over was clear, expressive, and perfectly matched my book’s tone amazing audio quality!",
    },
    {
      profileImage:
        "https://api.builder.io/api/v1/image/assets/15161154b48645df88fb0490ee5cc09b/2dfdd4bbf766071e4d8ea05ff1b3995b0960f381?placeholderIfAbsent=true",
      name: "Noah James",
      title: "Nutrition Coach",
      testimonial:
        "Their marketing helped my book reach real readers. Sales and engagement improved within weeks!",
    },
    {
      profileImage:
        "https://api.builder.io/api/v1/image/assets/15161154b48645df88fb0490ee5cc09b/bc1e43849e9a7da992977bbd8b59921440907c07?placeholderIfAbsent=true",
      name: "Emma Grace",
      title: "Marketing Consultant",
      testimonial:
        "They polished my manuscript perfectly. Every sentence flows better now truly professional editing support.",
    },
    {
      profileImage:
        "/review9.webp",
      name: "Ethan Michael",
      title: "Author & Speaker",
      testimonial:
        "I finally saw my book getting noticed online. Smart strategy and great communication throughout the process.",
    },
    {
      profileImage:
        "/review3.webp",
      name: "Ava Marie",
      title: "Fitness Expert",
      testimonial:
        "Listening to my story in professional narration felt incredible. They really brought my words to life.",
    },
    {
      profileImage:
        "/review2.webp",
      name: " Caleb M",
      title: "Tech Writer",
      testimonial:
        "The team truly captured my voice. It felt like reading my own thoughts, perfectly written and beautifully structured.",
    },
    {
      profileImage:
        "/review8.webp",
      name: "Tanya Brooks",
      title: "Creative Entrepreneur",
      testimonial:
        "The illustrations were full of life and color! Exactly what I imagined for my story, absolutely magical work.",
    },
    {
      profileImage:
        "/review1.webp",
      name: "Lena K",
      title: "Life & Business Coach",
      testimonial:
        "They made the whole publishing process effortless! My ebook looks professional and reached readers faster than I expected.",
    },
  ];

  return (
    <>
      <section className="testimonials-section">
        <div className="container">
          {/* Host Cards Section */}
          <div className="row g-3 mb-3">
            {hosts.map((host, index) => (
              <div key={index} className="col-12 col-md-6 col-lg-4">
                <HostCard
                  image={host.image}
                  name={host.name}
                  title={host.title}
                  icon={host.icon}
                />
              </div>
            ))}
          </div>

          {/* Testimonials Grid */}
          <div className="row g-3">
            {testimonials.map((testimonial, index) => (
              <div key={index} className="col-12 col-md-6 col-lg-4">
                <TestimonialCard
                  profileImage={testimonial.profileImage}
                  name={testimonial.name}
                  // title={testimonial.title}
                  rating={testimonial.rating}
                  testimonial={testimonial.testimonial}
                />
              </div>
            ))}
          </div>
        </div>
      </section>
    </>
  );
};

export default TestimonialsSection;
