"use client"
import React, { useState } from 'react';
import "./FaqSec.css";

const FAQItem = ({ question, answer, isOpen, onToggle }) => {
  return (
    <div className={`faq-item ${isOpen ? 'faq-item-open' : 'faq-item-closed'}`}>
      <button
        onClick={onToggle}
        className="faq-question-btn"
      >
        <div className="faq-icon-container">
          <div className={`faq-toggle-icon ${isOpen ? 'faq-toggle-open' : 'faq-toggle-closed'}`}>
            {isOpen ? '−' : '+'}
          </div>
        </div>
        <h3 className={`faq-question ${isOpen ? 'faq-question-active' : 'faq-question-inactive'}`}>
          {question}
        </h3>
      </button>
      {isOpen && answer && (
        <div className="faq-answer-container">
          <div className="row">
            <div className="col-lg-10 col-md-12">
              <p className="faq-answer-text">
                {answer}
              </p>
            </div>
          </div>
        </div>
      )}
    </div>
  );
};

const FAQSection = () => {
  const [openIndex, setOpenIndex] = useState();

  const faqs = [
    {
      question: "What services does Elume Publishers offer?",
      answer: "Elume Publishers provides a full suite of eBook and print publishing services. That includes ghostwriting, editing, formatting, cover design, eBook publishing, audiobook production. We also provide children’s book development, book marketing, author website creation, and video book trailers."
    },
    {
      question: "Can Elume Publishers help turn my manuscript into a bestseller?",
      answer: "Yes. Elume Publishers focuses on quality and market-readiness. From expert editing to eye-catching design and strategic marketing. So, their comprehensive process is tailored to enhance your book's chances of becoming a bestseller."
    },
    {
      question: "Do I retain the rights to my book if I publish through Elume Publishers?",
      answer: "Yes, as a self-publishing service provider, Elume Publishers ensures that authors retain full rights to their books. You have complete ownership over your manuscript and published content."
    },
    {
      question: " How does the eBook publishing process work?",
      answer: "The process includes: Planning & Content Creation , Outlining and writing your content. Editing & Formatting , Polishing your manuscript and ensuring digital compatibility. Design & Packaging , Creating a professional layout and an engaging cover. Publishing & Distribution , Uploading to platforms like Amazon Kindle, Apple Books, and promoting it to your target audience."
    },
    {
      question: "Does Elume Publishers provide ghostwriting services?",
      answer: "Yes, they offer professional ghostwriting by experienced authors. Perhaps, you have a basic idea or an outline, their ghostwriters can craft a compelling. We build the well-structured book in your preferred genre."
    },
    {
      question: "What kind of support does Elume provide after publishing?",
      answer: "Elume Publishers offers post-publishing support such as book marketing (social media, press releases, blogs), video trailers, and author websites. Their goal is to help authors maximize visibility and reach the right audience."
    }
  ];

  return (
    <>
      <section className="faq-section-main">
        <div className="container-fluid">
          <div className="row justify-content-center">
            <div className="col-12">
              {/* Header Section */}
              <div className="row justify-content-center">
                <div className="col-lg-11 col-md-12">
                  <div className="faq-header text-center">
                    <h2 className="faq-title">
                      Frequently Asked <span className="faq-title-highlight">Questions</span>
                    </h2>
                    <p className="faq-subtitle">
                      Reach Out to Us for Further Assistance.
                    </p>
                  </div>
                </div>
              </div>

              {/* FAQ Items */}
              <div className="row justify-content-center">
                <div className="col-lg-12 col-md-12">
                  <div className="faq-container">
                    {faqs.map((faq, index) => (
                      <FAQItem
                        key={index}
                        question={faq.question}
                        answer={faq.answer}
                        isOpen={openIndex === index}
                        onToggle={() => setOpenIndex(openIndex === index ? -1 : index)}
                      />
                    ))}
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </section>
    </>
  );
};

export default FAQSection;