"use client";
import React, { useState, useEffect } from "react";
import { MapPin, Phone, Mail } from "lucide-react";
import "./Footer.css";
import Link from "next/link";
import Image from "next/image";

const Footer = () => {
  const [showModal, setShowModal] = useState(false);
  const [formData, setFormData] = useState({
    fullName: "",
    email: "",
    phone: "",
    message: "",
  });
  const [loading, setLoading] = useState(false);
  const [status, setStatus] = useState("");

  useEffect(() => {
    setShowModal(true);
  }, []);

  const handleClose = () => {
    setShowModal(false);
  };

  const handleInputChange = (field, value) => {
    setFormData((prev) => ({
      ...prev,
      [field]: value,
    }));
  };

  const handleSubmit = async (e) => {
    e.preventDefault();
    setLoading(true);
    setStatus("");

    const phoneRegex = /^[+]?[0-9]{10,15}$/;
    if (formData.phone && !phoneRegex.test(formData.phone)) {
      setStatus("Please enter a valid phone number.");
      setLoading(false);
      return;
    }

    const currentPageLink =
      typeof window !== "undefined" ? window.location.href : "";

    const apiFormData = {
      fullName: formData.fullName,
      email: formData.email,
      phone: formData.phone,
      budget: "",
      message: formData.message,
      pageLink: currentPageLink,
    };

    try {
      const res = await fetch("/api/sendEmail", {
        method: "POST",
        headers: { "Content-Type": "application/json" },
        body: JSON.stringify(apiFormData),
      });

      const data = await res.json();

      if (res.ok) {
        setStatus("Your message has been sent successfully!");
        setFormData({
          fullName: "",
          email: "",
          phone: "",
          message: "",
        });

        // Close modal after 2 seconds on success
        setTimeout(() => {
          setShowModal(false);
        }, 2000);
      } else {
        setStatus(data.message || "Something went wrong.");
      }

      setTimeout(() => setStatus(""), 3000);
    } catch (error) {
      setStatus("Failed to send email. Please try again later.");
      setTimeout(() => setStatus(""), 3000);
    } finally {
      setLoading(false);
    }
  };

  return (
    <>
      {/* Video Section */}
      <div className="video-section">
        <div className="container-fluid">
          <div className="row justify-content-center">
            <div className="col-12">
              <div className="video-container">
                <video
                  className="company-video"
                  autoPlay
                  loop
                  muted
                  playsInline
                >
                  <source src="/logo.mp4" type="video/mp4" />
                </video>
              </div>
            </div>
          </div>
        </div>
      </div>

      <footer className="footer-main">
        <div className="container-fluid">
          <div className="row justify-content-center">
            <div className="col-12">
              <div className="row">
                <div className="col-lg-4 col-md-12">
                  <div className="footer-newsletter">
                    <h3 className="footer-section-title">
                      Subscribe to Our Newsletter
                    </h3>
                    <p className="footer-newsletter-text">
                      Subscribe our newsletter to get our latest <br /> Update &
                      news
                    </p>
                    <div className="newsletter-form-container">
                      <div className="newsletter-input-wrapper">
                        <input
                          type="email"
                          placeholder="Enter your email"
                          className="newsletter-input"
                        />
                        <button className="newsletter-btn">
                          <span className="newsletter-btn-text">Subscribe</span>
                          <svg
                            className="newsletter-btn-arrow"
                            width="15"
                            height="15"
                            viewBox="0 0 24 24"
                            fill="none"
                            stroke="currentColor"
                            strokeWidth="2"
                            strokeLinecap="round"
                            strokeLinejoin="round"
                          >
                            <path d="m9 18 6-6-6-6" />
                          </svg>
                        </button>
                      </div>
                    </div>
                  </div>
                </div>

                <div className="col-lg-8">
                  <div className="row">
                    <div className=" col-lg-3 col-md-6">
                      <div className="footer-nav-section">
                        <h4 className="footer-section-title">Menu</h4>
                        <ul className="footer-nav-list">
                          <li className="footer-nav-item">
                            <Link href="/" className="footer-nav-link">
                              Home
                            </Link>
                          </li>
                          <li className="footer-nav-item">
                            <Link href="/about-us" className="footer-nav-link">
                              About Us
                            </Link>
                          </li>
                          <li className="footer-nav-item">
                            <Link href="/services" className="footer-nav-link">
                              Services
                            </Link>
                          </li>
                          <li className="footer-nav-item">
                            <Link href="/genres" className="footer-nav-link">
                              Genres
                            </Link>
                          </li>
                          <li className="footer-nav-item">
                            <Link href="/blogs" className="footer-nav-link">
                              Blogs
                            </Link>
                          </li>
                        </ul>
                      </div>
                    </div>

                    <div className="col-xl-3 col-lg-3 col-md-6 col-sm-6">
                      <div className="footer-nav-section">
                        <h4 className="footer-section-title">Services</h4>
                        <ul className="footer-nav-list">
                          <li className="footer-nav-item">
                            <Link
                              href="/book-publishing"
                              className="footer-nav-link"
                            >
                              Book Publishing
                            </Link>
                          </li>
                          <li className="footer-nav-item">
                            <Link
                              href="/ghostwriting"
                              className="footer-nav-link"
                            >
                              Ghostwriting
                            </Link>
                          </li>
                          <li className="footer-nav-item">
                            <Link
                              href="/book-editing"
                              className="footer-nav-link"
                            >
                              Book Editing
                            </Link>
                          </li>
                          <li className="footer-nav-item">
                            <Link
                              href="/children-book-writing"
                              className="footer-nav-link"
                            >
                              Children's Book
                            </Link>
                          </li>
                          <li className="footer-nav-item">
                            <Link
                              href="/book-marketing"
                              className="footer-nav-link"
                            >
                              Book Marketing
                            </Link>
                          </li>
                        </ul>
                      </div>
                    </div>

                    <div className="col-lg-3 col-md-6">
                      <div className="footer-nav-section">
                        <h4 className="footer-section-title">Useful links</h4>
                        <ul className="footer-nav-list">
                          <li className="footer-nav-item">
                            <Link
                              href="/terms-and-conditions"
                              className="footer-nav-link"
                            >
                              Terms & Conditions
                            </Link>
                          </li>
                          <li className="footer-nav-item">
                            <Link
                              href="/privacy-policy"
                              className="footer-nav-link"
                            >
                              Privacy Policy
                            </Link>
                          </li>
                          <li className="footer-nav-item">
                            <Link
                              href="/testimonials"
                              className="footer-nav-link"
                            >
                              Testimonials
                            </Link>
                          </li>
                          <li className="footer-nav-item">
                            <Link
                              href="/contact-us"
                              className="footer-nav-link"
                            >
                              Contact Us
                            </Link>
                          </li>
                        </ul>
                      </div>
                    </div>

                    <div className="col-lg-3 col-md-6 col-sm-6">
                      <div className="footer-contact-section">
                        <h4 className="footer-section-title">Contact us</h4>
                        <div className="footer-contact-list">
                          <div className="footer-contact-item">
                            <MapPin className="footer-contact-icon" size={18} />
                            <address className="footer-contact-text">
                              119 S Western Ave Unit 1 #238Chicago, IL 60612
                            </address>
                          </div>
                          <div className="footer-contact-item">
                            <Phone className="footer-contact-icon" size={18} />
                            <Link
                              href="tel:12179069606"
                              className="footer-contact-link"
                            >
                              +1 (217) 906 9606
                            </Link>
                          </div>
                          <div className="footer-contact-item">
                            <Phone className="footer-contact-icon" size={18} />
                            <Link
                              href="tel:13122483277"
                              className="footer-contact-link"
                            >
                              +1 (312) 248-3277
                            </Link>
                          </div>
                          <div className="footer-contact-item">
                            <Mail className="footer-contact-icon" size={18} />
                            <Link
                              href="mailto:info@elumepublishers.com"
                              className="footer-contact-link footer-email-link"
                              target="_blank"
                              rel="noopener noreferrer"
                            >
                              info@elumepublishers.com
                            </Link>
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </footer>

      {/* Coupon Modal */}
      <div
        className={`modal fade ${showModal ? "show" : ""}`}
        id="couponModal"
        tabIndex="-1"
        aria-labelledby="couponModalLabel"
        aria-hidden={!showModal}
        style={{ display: showModal ? "block" : "none" }}
      >
        <div className="modal-dialog modal-dialog-centered">
          <div className="modal-content coupon-modal-content">
            <div className="modal-header coupon-modal-header">
              <button
                type="button"
                className="btn-close"
                onClick={handleClose}
                data-bs-dismiss="modal"
                aria-label="Close"
              ></button>
            </div>
            <div className="modal-body coupon-modal-body">
              <div className="text-center mb-4">
                <Image
                  src="https://api.builder.io/api/v1/image/assets/TEMP/0f6316e43d7ca537efe5a3930c083f7eb8c81521?width=468"
                  alt="Elume Publisher Logo"
                  width={351}
                  height={440}
                  className="coupon-logo"
                />
                <h2 className="coupon-title">
                  Activate Upto 50% OFF Discount Coupon!
                </h2>
                {/* <p className="coupon-subtitle">Last 6 Coupons Left</p> */}
              </div>

              <form onSubmit={handleSubmit} className="coupon-form">
                <div className="mb-3">
                  <input
                    type="text"
                    className="form-control coupon-input"
                    placeholder="Full Name"
                    value={formData.fullName}
                    onChange={(e) =>
                      handleInputChange("fullName", e.target.value)
                    }
                    required
                  />
                </div>

                <div className="mb-3">
                  <input
                    type="email"
                    className="form-control coupon-input"
                    placeholder="Email Address"
                    value={formData.email}
                    onChange={(e) => handleInputChange("email", e.target.value)}
                    required
                  />
                </div>

                <div className="mb-3">
                  <input
                    type="tel"
                    className="form-control coupon-input"
                    placeholder="Phone Number"
                    value={formData.phone}
                    onChange={(e) => handleInputChange("phone", e.target.value)}
                    pattern="^[+]?[0-9]{10,15}$"
                    title="Enter a valid phone number (10–15 digits)"
                    required
                  />
                </div>

                <div className="mb-3">
                  <input
                    type="text"
                    className="form-control coupon-input"
                    placeholder="Enter About Your Book"
                    value={formData.message}
                    onChange={(e) =>
                      handleInputChange("message", e.target.value)
                    }
                    required
                  />
                </div>

                <button
                  type="submit"
                  className="btn coupon-submit-btn w-100"
                  disabled={loading}
                >
                  {loading ? "Sending..." : "Schedule Expert Consultation"}
                </button>

                {/* Loader */}
                {loading && (
                  <div className="modal-loader-container mt-3">
                    <div className="modal-loader"></div>
                  </div>
                )}

                {/* Status Message */}
                {status && (
                  <div className="mt-3">
                    <p
                      className={`modal-status-message ${
                        !status ? "hidden" : ""
                      }`}
                    >
                      {status}
                    </p>
                  </div>
                )}
              </form>
            </div>
          </div>
        </div>
      </div>

      {/* Modal Backdrop */}
      {showModal && (
        <div className="modal-backdrop fade show" onClick={handleClose}></div>
      )}
    </>
  );
};

export default Footer;
