"use client";
import React, { useState } from "react";
import { Swiper, SwiperSlide } from "swiper/react";
import { Autoplay, FreeMode } from "swiper/modules";
import "swiper/css";
import "swiper/css/autoplay";
import "./PortfolioSec.css";
import "swiper/css/free-mode";
import Image from "next/image";

const PortfolioSection = ({ titleDark, titleHighlight, para }) => {
  const [activeFilter, setActiveFilter] = useState("All");

  const categories = [
    "All",
    "Romance",
    "Fiction",
    "Non-Fiction",
    "Kids",
    "History",
    "Biography",
    "Fantasy",
    "Horror",
    "Ghostwriting",
    "Family",
  ];

  const firstRow = categories.slice(0, 15);

  const books = [
    {
      src: "https://api.builder.io/api/v1/image/assets/TEMP/86b709f4a01908c20b2dc7de7593297aff6d22ee?width=400",
      alt: "Book cover 1",
    },
    {
      src: "https://api.builder.io/api/v1/image/assets/TEMP/27152a6dc29a7f9aacc23d6a37a631a2461ac1a0?width=400",
      alt: "Book cover 2",
    },
    {
      src: "https://api.builder.io/api/v1/image/assets/TEMP/cc9addd8b0f55fc00cac3c3ccf3548580da4cec5?width=400",
      alt: "Book cover 3",
    },

    {
      src: "https://api.builder.io/api/v1/image/assets/TEMP/12fe660a01e59007d870cf80f256c5092fa3f037?width=400",
      alt: "Book cover 5",
    },
    {
      src: "https://api.builder.io/api/v1/image/assets/TEMP/f8f771c8befdee38a354b6e9ebd1345662aaa100?width=400",
      alt: "Book cover 6",
    },
    {
      src: "https://api.builder.io/api/v1/image/assets/TEMP/c6cc0c8c80251d6027950f752786d5724826f9c8?width=400",
      alt: "Book cover 7",
    },
    {
      src: "https://api.builder.io/api/v1/image/assets/TEMP/86b709f4a01908c20b2dc7de7593297aff6d22ee?width=400",
      alt: "Book cover 1",
    },
    {
      src: "https://api.builder.io/api/v1/image/assets/TEMP/27152a6dc29a7f9aacc23d6a37a631a2461ac1a0?width=400",
      alt: "Book cover 2",
    },
    {
      src: "https://api.builder.io/api/v1/image/assets/TEMP/cc9addd8b0f55fc00cac3c3ccf3548580da4cec5?width=400",
      alt: "Book cover 3",
    },
    {
      src: "https://api.builder.io/api/v1/image/assets/TEMP/12fe660a01e59007d870cf80f256c5092fa3f037?width=400",
      alt: "Book cover 5",
    },
    {
      src: "https://api.builder.io/api/v1/image/assets/TEMP/f8f771c8befdee38a354b6e9ebd1345662aaa100?width=400",
      alt: "Book cover 6",
    },
    {
      src: "https://api.builder.io/api/v1/image/assets/TEMP/c6cc0c8c80251d6027950f752786d5724826f9c8?width=400",
      alt: "Book cover 7",
    },
  ];

  return (
    <section className="portfolio-section position-relative rounded-4">
      <div className="container-fluid">
        <div className="row justify-content-center">
          <div className="col-12">
            <Image
              src="https://api.builder.io/api/v1/image/assets/TEMP/e5324ddc0016bb7e55347697982c34f8e6a7d144?width=3720"
              alt="Portfolio background"
              fill
              className="portfolio-bg"
            />

            <div className="portfolio-header text-center">
              <h1 className="portfolio-title">
                <span className="text-dark">{titleDark} </span>
                <span className="testimonials-title-highlight">
                  {titleHighlight}
                </span>
              </h1>
              <p className="portfolio-subtitle">{para}</p>
            </div>

            <nav className="portfolio-filters text-center">
              <div className="row mb-3 justify-content-center">
                {firstRow.map((category, idx) => (
                  <div key={idx} className="col-lg-2 col-6 col-md-3 mb-3 col-6">
                    <button
                      className={`btn w-100 rounded-pill filter-btn ${
                        activeFilter === category ? "active" : ""
                      }`}
                      onClick={() => setActiveFilter(category)}
                    >
                      {category}
                    </button>
                  </div>
                ))}
              </div>
            </nav>

            <div className="portfolio-slider">
              <Swiper
                slidesPerView={1}
                autoplay={{ delay: 2500, disableOnInteraction: false }}
                spaceBetween={30}
                centeredSlides={true}
                loop={true}
                freeMode={false}
                modules={[Autoplay]}
                className="mySwiper"
                breakpoints={{
                  576: {
                    slidesPerView: 1,
                    spaceBetween: 20,
                    centeredSlides: true,
                  },
                  768: {
                    slidesPerView: 2,
                    spaceBetween: 30,
                    centeredSlides: true,
                  },
                  1024: {
                    slidesPerView: 6,
                    spaceBetween: 50,
                    centeredSlides: true,
                  },
                  1450: {
                    slidesPerView: 7,
                    spaceBetween: 100,
                    centeredSlides: true,
                  },
                }}
              >
                {books.map((book, index) => (
                  <SwiperSlide key={index} className="book-slide">
                    <Image
                      src={book.src}
                      alt={book.alt}
                      width={251}
                      height={440}
                      className="book-cover"
                    />
                  </SwiperSlide>
                ))}
              </Swiper>
            </div>
          </div>
        </div>
      </div>
    </section>
  );
};

export default PortfolioSection;
