"use client";
import React from "react";
import "./ProcessSec2.css";
import Image from "next/image";

const ProcessSection2 = () => {
  return (
    <section className="process-main">
      <div className="container-fluid">
        <div className="row justify-content-center">
          <div className="col-12">
            <div className="process-main-content">
              {/* Main Title Section */}
              <div className="row justify-content-center mb-5">
                <div className="col-lg-12 col-md-12">
                  <div className="text-center">
                    <h1 className="processs-title">
                      <span className="text-dark">
                        How We Take Manuscript to
                      </span>{" "}
                      <span className="processs-title-highlight">
                        Quality Story Book
                      </span>
                    </h1>
                    <p className="process-subtitle">
                      We walk with you from your first draft all the way to a
                      finished storybook you can proudly share with the world.
                    </p>
                  </div>
                </div>
              </div>

              {/* Steps Grid */}
              <div className="row justify-content-center ">
                <div className="col-lg-12">
                  <div className="row steps-grid mt-5">
                    {/* Step 1 - Get Started */}
                    <div className="col-lg-2 col-md-6 col-12">
                      <div className="step-item">
                        <div className="step-info">
                          <h3 className="step-heading">Reading Manuscript</h3>
                        </div>

                        <div className="step-img-wrapper">
                          <Image
                            src="/step-01.webp"
                            alt="Get Started"
                            width={251}
                            height={320}
                            className="step-img"
                          />
                        </div>

                        <div className="step-info">
                          <p className="step-text">
                            Each good book starts with an idea of decent story.
                            First, we take the time to read every manuscript
                            carefully. Learn everything about your message, and
                            what makes your story special.
                          </p>
                        </div>
                      </div>
                    </div>

                    {/* Step 2 - Revisions & Feedback */}
                    <div className="col-lg-2 col-md-6 col-12">
                      <div className="step-item">
                        <div className="step-info">
                          <p className="step-text">
                            Our editors jump in to help improve content at every
                            aspect. We look at structure, grammar, flow, and
                            clarity. Improving reads smoothly while staying tone
                            closely to genre.
                          </p>
                        </div>
                        <div className="step-img-wrapper">
                          <Image
                            src="/step-02.webp"
                            alt="Revisions & Feedback"
                            width={250}
                            height={320}
                            className="step-img"
                          />
                        </div>
                        <div className="step-info">
                          <h3 className="step-heading"> Polishing Content</h3>
                        </div>
                      </div>
                    </div>

                    {/* Step 3 - Proofreading & Editing */}
                    <div className=" col-lg-2 col-md-6 col-12">
                      <div className="step-item">
                        <div className="step-info">
                          <h3 className="step-heading">
                            Illustrations <br /> (if needed)
                          </h3>
                        </div>

                        <div className="step-img-wrapper">
                          <Image
                            src="/step-03.webp"
                            alt="Proofreading & Editing"
                            width={260}
                            height={320}
                            className="step-img"
                          />
                        </div>
                        <div className="step-info">
                          <p className="step-text">
                            If story calls for illustrations, specifically in
                            children’s books. Our pro artists step in to add
                            visual magic. Every image is thoughtfully created to
                            match the theme of story.
                          </p>
                        </div>
                      </div>
                    </div>

                    {/* Step 4 - Final Creative Touches */}
                    <div className="col-lg-2 col-md-6 col-12">
                      <div className="step-item">
                        <div className="step-info">
                          <p className="step-text">
                            Next step, we carefully format and lay out your
                            pages to make a professional impression for the
                            reading experience. Excellence for book print and
                            publication.
                          </p>
                        </div>
                        <div className="step-img-wrapper">
                          <Image
                            src="/step-04.webp"
                            alt="Final Creative Touches"
                            width={259}
                            height={320}
                            className="step-img"
                          />
                        </div>

                        <div className="step-info">
                          <h3 className="step-heading">Book Design & Format</h3>
                        </div>
                      </div>
                    </div>

                    {/* Step 5 - Publication */}
                    <div className="col-lg-2 col-md-6 col-12">
                      <div className="step-item">
                        <div className="step-info">
                          <h3 className="step-heading">Book Cover Design</h3>
                        </div>

                        <div className="step-img-wrapper">
                          <Image
                            src="/step-05.webp"
                            alt="Publication"
                            width={256}
                            height={320}
                            className="step-img"
                          />
                        </div>
                        <div className="step-info">
                          <p className="step-text">
                            The book cover is the first thing readers see, this
                            is the first impression. We design it to deliver
                            exactly what inside the book. Our designers craft a
                            cover that captures the heart of story.
                          </p>
                        </div>
                      </div>
                    </div>

                    {/* Step 6 - Promotion */}
                    <div className="col-lg-2 col-md-6 col-12">
                      <div className="step-item">
                        <div className="step-info">
                          <p className="step-text">
                            Once everything's ready, we publish your book to
                            exact target audience who wants to read inside
                            story. We further support you on promotion and
                            marketing as well.
                          </p>
                        </div>
                        <div className="step-img-wrapper">
                          <Image
                            src="/step-06.webp"
                            alt="Promotion"
                            width={251}
                            height={320}
                            className="step-img"
                          />
                        </div>

                        <div className="step-info">
                          <h3 className="step-heading">
                            Ready to <br /> Publish
                          </h3>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
  );
};

export default ProcessSection2;
