"use client";
import React from "react";
import "./PublishingSec.css";
import Image from "next/image";

const PublishingPlatforms = () => {
  const firstRowPlatforms = [
    {
      src: "https://api.builder.io/api/v1/image/assets/15161154b48645df88fb0490ee5cc09b/50aa17fa29b7577a953da7eb5068f87ab13fb7ea?placeholderIfAbsent=true",
      alt: "Amazon Publishing platform",
      aspectRatio: "3.73",
      width: "228px",
    },
    {
      src: "https://api.builder.io/api/v1/image/assets/15161154b48645df88fb0490ee5cc09b/20a8d9ae20122ec638c02fa526dedfb29304e647?placeholderIfAbsent=true",
      alt: "Barnes & Noble Publishing platform",
      aspectRatio: "4.03",
      width: "214px",
    },
    {
      src: "https://api.builder.io/api/v1/image/assets/15161154b48645df88fb0490ee5cc09b/12d695109cf6dae2ef98ec67d59b757b0bd86d68?placeholderIfAbsent=true",
      alt: "Kobo Publishing platform",
      aspectRatio: "3.55",
      width: "188px",
    },
    {
      src: "https://api.builder.io/api/v1/image/assets/15161154b48645df88fb0490ee5cc09b/233377a6cd473617ace63f915aa07ddde783f7e4?placeholderIfAbsent=true",
      alt: "Apple Books Publishing platform",
      aspectRatio: "3.1",
      width: "189px",
    },
    {
      src: "https://api.builder.io/api/v1/image/assets/15161154b48645df88fb0490ee5cc09b/402b7cc9d5c45c6a57ba8845a506c40ebf0196b5?placeholderIfAbsent=true",
      alt: "Google Play Publishing platform",
      aspectRatio: "6.58",
      width: "230px",
    },
  ];

  const secondRowPlatforms = [
    {
      src: "https://api.builder.io/api/v1/image/assets/15161154b48645df88fb0490ee5cc09b/1a06fb307681a95c34a75736688554fe3c38738f?placeholderIfAbsent=true",
      alt: "Scribd Publishing platform",
      aspectRatio: "2.64",
      width: "153px",
    },
    {
      src: "https://api.builder.io/api/v1/image/assets/15161154b48645df88fb0490ee5cc09b/cf6020cdb86cbb8abeef2d9d05e25f8f923fdaef?placeholderIfAbsent=true",
      alt: "Audible Publishing platform",
      aspectRatio: "3.75",
      width: "210px",
    },
    {
      src: "https://api.builder.io/api/v1/image/assets/15161154b48645df88fb0490ee5cc09b/e784d78506927f621cc78f1f30501d86493f9ca6?placeholderIfAbsent=true",
      alt: "IngramSpark Publishing platform",
      aspectRatio: "4.15",
      width: "199px",
    },
    {
      src: "https://api.builder.io/api/v1/image/assets/15161154b48645df88fb0490ee5cc09b/37fb28cef66df7a88bc0ae9e6094f515f579eea5?placeholderIfAbsent=true",
      alt: "Draft2Digital Publishing platform",
      aspectRatio: "3.58",
      width: "172px",
    },
    {
      src: "https://api.builder.io/api/v1/image/assets/15161154b48645df88fb0490ee5cc09b/99563e9b0899d3e3e9aeb0d363c41cf3e15ccfa9?placeholderIfAbsent=true",
      alt: "Smashwords Publishing platform",
      aspectRatio: "3.76",
      width: "214px",
    },
  ];

  return (
    <>
      <section className="publishing-platforms-main">
        <div className="container">
          <div className="row justify-content-center">
            <div className="col-12">
              {/* Header Section */}
              <div className="row justify-content-center">
                <div className="col-lg-11 col-md-12">
                  <div className="publishing-header text-center">
                    <h2 className="publishing-title">
                      Time to{" "}
                      <span className="publishing-title-highlight">
                        Publish eBook
                      </span>{" "}
                      Today
                    </h2>
                  </div>
                </div>
              </div>

              {/* First Row Platforms */}
              <div className="row justify-content-center platforms-row">
                {firstRowPlatforms.map((platform, index) => (
                  <div key={index} className="col-lg-2 col-md-4 col-8">
                    <div className="platform-logo-container">
                      <Image
                        src={platform.src}
                        alt={platform.alt}
                        width={500}
                        height={400}
                        className="platform-logo"
                        style={{ aspectRatio: platform.aspectRatio }}
                      />
                    </div>
                  </div>
                ))}
              </div>

              {/* Second Row Platforms */}
              <div className="row justify-content-center platforms-row">
                {secondRowPlatforms.map((platform, index) => (
                  <div key={index} className="col-lg-2 col-md-4 col-8">
                    <div className="platform-logo-container">
                      <Image
                        src={platform.src}
                        alt={platform.alt}
                        width={500}
                        height={400}
                        className="platform-logo"
                        style={{ aspectRatio: platform.aspectRatio }}
                      />
                    </div>
                  </div>
                ))}
              </div>
            </div>
          </div>
        </div>
      </section>
    </>
  );
};

export default PublishingPlatforms;
