"use client";
import React from "react";
import "./ServicesSection.css";
import Link from "next/link";
import Image from "next/image";
import { FiArrowUpRight } from "react-icons/fi";

const ServiceCard = ({ icon, title, description }) => {
  return (
    <div className="service-card-wrapper">
      <div className="service-icon-container">
        <Image
          src={icon}
          width={100}
          height={101}
          alt={`${title} icon`}
          className="service-icon"
        />
      </div>
      <div className="service-card-content">
        <div className="service-card-inner">
          <h3 className="service-title">{title}</h3>
          <p className="service-description">{description}</p>
          <button
            className="service-btn"
            data-bs-toggle="modal"
            data-bs-target="#couponModal"
          >
            <div className="service-btn-content">
              <span className="service-btn-text">Get a Quote</span>
              <FiArrowUpRight className="service-btn-arrow" />
            </div>
          </button>
        </div>
      </div>
    </div>
  );
};

const ServicesSection = () => {
  const services = [
    {
      icon: "https://api.builder.io/api/v1/image/assets/15161154b48645df88fb0490ee5cc09b/cb95e8c45b9e69b5175cad580c74c2e301432663?placeholderIfAbsent=true",
      title: "Book Publishing",
      description:
        "We manage the entire publishing process from formatting and cover design on platforms. Our experts ensure the book meets industry standards, reaches the right audience, and stands out in a market.",
    },
    {
      icon: "https://api.builder.io/api/v1/image/assets/15161154b48645df88fb0490ee5cc09b/82a842b57f0a9310313a09acc29fcdb06e89dd20?placeholderIfAbsent=true",
      title: "Ghostwriting",
      description:
        "Our professional book writing service transforms your ideas into compelling manuscripts, crafting original fiction or nonfiction tailored to your voice, goals, and specific target audience.",
    },
    {
      icon: "https://api.builder.io/api/v1/image/assets/15161154b48645df88fb0490ee5cc09b/2b6d5daa33fd89a804c102eeca16d5d2a57c7d28?placeholderIfAbsent=true",
      title: "Book Editing",
      description:
        "Our experienced editors enhance your manuscript’s grammar, structure, tone, and flow improving readability while preserving your unique voice to ensure it’s polished and ready for publication.",
    },
    {
      icon: "https://api.builder.io/api/v1/image/assets/15161154b48645df88fb0490ee5cc09b/22768df74ebd424a40afce6951382d4775fd378f?placeholderIfAbsent=true",
      title: "Audio Book Recording",
      description:
        "Expand your audience with professional audiobook services. From narration to sound design, we create high-quality audio versions that engage listeners across all major platforms.",
    },
    {
      icon: "/icon5.webp",
      title: "Children's Book Writing",
      description:
        "Our team of writers, illustrators, and designers specializes in creating books for young readers. We combine captivating stories with vibrant visuals to educate, entertain, and inspire children.",
    },
    {
      icon: "https://api.builder.io/api/v1/image/assets/15161154b48645df88fb0490ee5cc09b/ebf78c1309ca9784d8a98f3521e6e850a64deb04?placeholderIfAbsent=true",
      title: "Book Marketing",
      description:
        "Maximize your book’s reach with strategic marketing. From social media and press releases to blogs and book trailers, we boost visibility, attract readers, and drive sales where it matters most.",
    },
    {
      icon: "/icon13.webp",
      title: "Book Printing",
      description:
        "Whether you need on-demand copies or large-scale production, we make it easy to print a book with precision. Our high-quality printing ensures every copy feels premium and reader-worthy.",
    },
    {
      icon: "https://api.builder.io/api/v1/image/assets/15161154b48645df88fb0490ee5cc09b/eb2a9d2daf447dd86474c15096869121aaecf788?placeholderIfAbsent=true",
      title: "Author Website Design",
      description:
        "Build your online presence with our author website design services. We create custom, user-friendly websites that showcase your books, reflect your brand, and grow your audience.",
    },
    {
      icon: "https://api.builder.io/api/v1/image/assets/15161154b48645df88fb0490ee5cc09b/f98974e93f00b00e9dea26dbe1d31b1b836873be?placeholderIfAbsent=true",
      title: "Book Trailer Production",
      description:
        "Capture attention and spark excitement with cinematic book trailers. Animated or live-action, our trailers showcase your story’s essence and engage audiences across all major digital platforms.",
    },
  ];

  return (
    <>
      <section className="services-main">
        {/* Top Background Image */}
        <div className="services-background services-background-top">
          <Image
            src="/top.webp"
            alt="Background Top"
            width={1860}
            height={668}
            className="services-bg-image"
          />
        </div>

        {/* Bottom Background Image */}
        <div className="services-background services-background-bottom">
          <Image
            src="https://api.builder.io/api/v1/image/assets/15161154b48645df88fb0490ee5cc09b/2cdc38d14e5b9b6cf8ec6db182ed5960261b0a4d?placeholderIfAbsent=true"
            alt="Background Bottom"
            width={1860}
            height={668}
            className="services-bg-image"
          />
        </div>

        <div className="container">
          <div className="row justify-content-center">
            <div className="col-12">
              {/* Header Section */}
              <div className="row justify-content-center">
                <div className="col-lg-12 col-md-12">
                  <div className="services-header text-center">
                    <h2 className="services-title">
                      Elume{" "}
                      <span className="services-title-highlight">
                        Publishers Services
                      </span>
                    </h2>
                    <p className="services-subtitle">
                      We have huge range our eBook comprehensive services that
                      can take all your burdens off about self-publishing. Elume
                      Publishers stands among the best book publishers in
                      Houston.
                    </p>
                  </div>
                </div>
              </div>

              {/* Services Grid */}
              <div className="row justify-content-center services-grid">
                {services.map((service, index) => (
                  <div key={index} className="col-lg-4 col-md-6 col-12">
                    <ServiceCard {...service} />
                  </div>
                ))}
              </div>

              {/* Discover More Button */}
              <div className="row justify-content-center">
                <div className="col-auto">
                  <Link href={"/services"}>
                    <button className="discover-more-btn">
                      <span className="discover-more-text">Discover More</span>
                    </button>
                  </Link>
                </div>
              </div>
            </div>
          </div>
        </div>
      </section>
    </>
  );
};

export default ServicesSection;
