import GhostCta from "@/components/GhostwritingPage/Cta/GhostCta";
import FAQSection from "@/components/GhostwritingPage/FAQSection/FAQSection";
import GhostwritingSection from "@/components/GhostwritingPage/GhostwritingSec/GhostwritingSec";
import GhostwritingWorkflow from "@/components/GhostwritingPage/GhostwritingWorkflow/GhostwritingWorkflow";
import Hero from "@/components/GhostwritingPage/HeroSec/Hero";
import WhyChooseSection from "@/components/GhostwritingPage/WhyChooseSec/WhyChooseSec";
import ContactForm from "@/components/landingPage/ContactForm/ContactForm";
import PortfolioSection from "@/components/landingPage/PortfolioSec/PortfolioSec";
import Image from "next/image";

export const metadata = {
  title: "Audiobook Recording | Big Audio Book Publishers USA",
  description:
    " High-quality audiobook recording services for all genres. Great for kids’ books, fiction, and nonfiction. Make your book heard on Audible.",
};

const heroData = {
  heading1: (
    <h1 className="hero-titles">
      <span className="hero-title-highlight">
        Audiobook <span className="black">Recording That</span> That Brings
        Stories to Life
      </span>
    </h1>
  ),
  para: "Elume Publishers offers professional audiobook recording services that turn your manuscript into an engaging audio experience. From narration to mastering, we help authors reach new audiences through powerful, polished, and immersive storytelling.",
};

const ghostData = {
  heading1: (
    <>
      <h1 className="ghostwriting-title-black">What Is</h1>
      <h1 className="ghostwriting-title-orange">Book Recording?</h1>
    </>
  ),
  para1:
    "Audiobook recording transforms your written book into an audio format, complete with narration, editing, and sound mastering. Whether you're recording an audiobook for fiction, nonfiction, or audiobooks for kids, quality voice work and production make all the difference.",
  para2:
    "At Elume, we manage the entire process, delivering professional-grade audio ready for platforms like Audible. We’ve also worked with big audiobook publishers, ensuring high-quality standards every time.",
  image: (
    <Image
      src="/audiobook1.webp"
      alt="Ghostwriting illustration"
      width={694}
      height={553}
      className="ghostwriting-image"
    />
  ),
};

const ghostCta = {
  heading1: (
    <h1 className="hero-main-title">
      Your Words, Brought to Life <br />
      <span className="text-orange">Let’s Record</span> an Audio{" "}
      <span className="text-orange">That Connects.</span>
    </h1>
  ),
  image: (
    <Image
      src="/audiobook2.webp"
      alt="Ghost writing promotional banner"
      width={1600}
      height={437}
      className="hero-background-image"
    />
  ),
};

const chooseSec = {
  features: (
    <ul>
      <li>We make your words sound as good as they read.</li>
      <li>Studio-quality sound and experienced narrators</li>
      <li>Perfect for all genres, including audiobooks for kids</li>
      <li>Proven with big audiobook publishers</li>
      <li>Compatible with best Audible audiobooks standards</li>
      <li> Let your book be heard.</li>
    </ul>
  ),

  heading1: <h2 className="why-choose-title">Why Choose Elume Publishers?</h2>,
  image: (
    <Image
      src="/audiobook3.webp"
      width={785}
      height={664}
      alt="Book cover showcase"
      className="book-main"
    />
  ),
};

const ghostWorkflow = {
  mainHeading: (
    <h1 className="workflow-title">
      How Our <span className="text-orange">Audiobook Recording</span> Process
      Work?
    </h1>
  ),
  mainPara:
    "Our audiobook recording process turns your manuscript into a powerful listening experience with professional narration, editing, and mastering that ensures your story sounds polished, captivating, and ready for platforms like Audible.",

  heading1: <h3 className="step-title orange">Send Your Manuscript</h3>,
  para1:
    "We start with your approved manuscript and discuss tone, genre, and narrator preferences. Whether you’re creating content for adults or audiobooks for kids, we help plan the best recording approach for your audience and platform.",

  heading2: <h3 className="step-title gray">Recording and Production</h3>,
  para2:
    "Professional voice talent narrates your book in a controlled studio environment. We manage pacing, tone, clarity, and character voices if needed. Our audiobook recording includes editing, noise reduction, and mastering for seamless playback.",

  heading3: <h3 className="step-title orange">Final Files Ready for Upload</h3>,
  para3:
    "After final review and quality checks, we deliver ACX-compliant audio files ready for Audible, iTunes, and other platforms. Whether you're recording an audiobook for retail or royalty distribution, Elume gets it done right.",
};

const faqs = [
  {
    question: "What does audiobook recording include?",
    answer:
      "Our audiobook recording includes narration, editing, sound mastering, and final file delivery everything needed to publish on Audible, iTunes, or other platforms professionally.",
  },
  {
    question: "Can I create audiobooks for kids?",
    answer:
      "Yes! We specialize in audiobooks for kids, using friendly narration, playful tone, and clear audio that keeps young listeners engaged and entertained throughout the story.",
  },
  {
    question: "How do I start recording an audiobook?",
    answer:
      "Start by submitting your final manuscript. We'll guide you through the full recording an audiobook process, including narrator selection, voice direction, and final mastering.",
  },
  {
    question: "Do you work with big audiobook publishers?",
    answer:
      "We’ve partnered with authors published through big audiobook publishers, delivering industry-standard quality that meets top platform requirements like Audible and ACX.",
  },
  {
    question: "What makes a great Audible audiobook?",
    answer:
      "The best Audible audiobooks combine strong narration, clean audio, and compelling storytelling. We help you achieve this through professional production, voice casting, and attention to detail.",
  },
];

const AudioBookPage = () => {
  return (
    <div>
      <Hero heroData={heroData} />
      <ContactForm />
      <GhostwritingSection ghostData={ghostData} />
      <GhostCta ghostCta={ghostCta} />
      <WhyChooseSection chooseSec={chooseSec} />
      <GhostwritingWorkflow ghostWorkflow={ghostWorkflow} />
      <PortfolioSection
        titleDark="Our"
        titleHighlight="Portfolio"
        para="Our portfolio blends storytelling and design, curated works that
                reflect originality, quality, and genre spanning creativity."
      />
      <FAQSection faqs={faqs} />
    </div>
  );
};

export default AudioBookPage;
