import GhostCta from "@/components/GhostwritingPage/Cta/GhostCta";
import FAQSection from "@/components/GhostwritingPage/FAQSection/FAQSection";
import GhostwritingSection from "@/components/GhostwritingPage/GhostwritingSec/GhostwritingSec";
import GhostwritingWorkflow from "@/components/GhostwritingPage/GhostwritingWorkflow/GhostwritingWorkflow";
import Hero from "@/components/GhostwritingPage/HeroSec/Hero";
import WhyChooseSection from "@/components/GhostwritingPage/WhyChooseSec/WhyChooseSec";
import ContactForm from "@/components/landingPage/ContactForm/ContactForm";
import PortfolioSection from "@/components/landingPage/PortfolioSec/PortfolioSec";
import Image from "next/image";

export const metadata = {
  title: "Book Editing Services | Edit Self-Published Books",
  description:
    "Polish your manuscript with our book editing services. We offer formatting, proofreading, and editing for self-published and traditional books.",
};

const heroData = {
  heading1: (
    <h1 className="hero-titles">
      <span className="hero-title-highlight">
        Book <span className="black">Editing Services</span> That Perfect Your
        Story
      </span>
    </h1>
  ),
  para: "At Elume Publishers, our book editing services refine every word of your manuscript. From grammar to flow, we help self-published and aspiring authors polish their work for a smooth, professional reading experience.",
};

const ghostData = {
  heading1: (
    <>
      <h1 className="ghostwriting-title-black">What Is</h1>
      <h1 className="ghostwriting-title-orange">Book Editing?</h1>
    </>
  ),
  para1:
    "Book editing goes beyond grammar it’s about enhancing your story, improving clarity, and fixing inconsistencies. Our team provides detailed corrections and thoughtful suggestions to strengthen your writing.",
  para2:
    "Whether you’re editing self-published books or preparing for traditional publishing, we offer structural, line, and copy editing. As one of the best book editing and proofreading services, Elume ensures your manuscript is clean, coherent, and publication-ready.",
  image: (
    <Image
      src="/bookedit1.webp"
      alt="Ghostwriting illustration"
      width={694}
      height={553}
      className="ghostwriting-image"
    />
  ),
};

const ghostCta = {
  heading1: (
    <h1 className="hero-main-title">
      Your Story, Perfected <br />
      <span className="text-orange">Let’s Polish</span> Your{" "}
      <span className="text-orange">Legacy Together.</span>
    </h1>
  ),
  image: (
    <Image
      src="/bookedit2.webp"
      alt="Ghost writing promotional banner"
      width={1600}
      height={437}
      className="hero-background-image"
    />
  ),
};

const chooseSec = {
  features: (
    <ul>
      <li>We care about your book as much as you do.</li>
      <li>Ideal for indie and traditional authors</li>
      <li>Experienced editors for every genre</li>
      <li>Includes formatting options</li>
      <li>Trusted for book editing and formatting services</li>
      <li> Let’s get your manuscript polished to perfection.</li>
    </ul>
  ),

  heading1: <h2 className="why-choose-title">Why Choose Elume Publishers?</h2>,
  image: (
    <Image
      src="/bookedit3.webp"
      width={785}
      height={664}
      alt="Book cover showcase"
      className="book-main"
    />
  ),
};

const ghostWorkflow = {
  mainHeading: (
    <h1 className="workflow-title">
      How Our <span className="text-orange">Book Editing</span> Process Work?
    </h1>
  ),
  mainPara:
    "Our book editing process is simple and thorough from reviewing your draft to refining structure, grammar, and formatting, we ensure your manuscript is polished, professional, and ready for publishing.",

  heading1: <h3 className="step-title orange">Submit Your Manuscript</h3>,
  para1:
    "Upload your draft, and we’ll assess its needs. Whether you're polishing a novel or editing self-published books, we assign the right editor to handle grammar, tone, structure, and more tailored to your genre and writing style.",

  heading2: <h3 className="step-title gray">We Edit, You Review</h3>,
  para2:
    "Your editor works through your manuscript with care fixing errors and enhancing flow. You’ll receive clean edits with tracked changes, so you’re always in control. Our book editing services are collaborative, clear, and built around your vision.",

  heading3: <h3 className="step-title orange">Final Formatting & Delivery</h3>,
  para3:
    "Once edits are approved, we finalize your manuscript. With our book editing and formatting services, you’ll receive a professionally formatted file ready for publication in both print and digital formats, based on your goals and platform.",
};

const faqs = [
  {
    question: "What do book editing services include?",
    answer:
      "Our book editing services cover grammar, structure, tone, consistency, and formatting giving you a professionally polished manuscript ready for agents, publishers, or self-publishing platforms.",
  },
  {
    question: "Do you edit self-published books?",
    answer:
      "Yes! We specialize in editing self-published books, helping indie authors enhance readability, professionalism, and publishing quality with expert-level feedback and careful editing.",
  },
  {
    question: "What’s the difference between editing and proofreading?",
    answer:
      "Editing improves content, structure, and flow. Proofreading fixes surface-level grammar and spelling. Our best book editing and proofreading services include both, depending on your manuscript’s needs.",
  },
  {
    question: "Can you help with book formatting too?",
    answer:
      "Absolutely. Our book editing and formatting services prepare your manuscript for publishing with clean layouts, correct margins, chapter styling, and formats suited for both print and eBooks.",
  },
  {
    question: " How long does the editing process take?",
    answer:
      "Editing timelines depend on length and depth of editing needed. Most projects take 2–6 weeks. We ensure thorough, timely edits so you can publish with confidence.",
  },
];

const BookEditingPage = () => {
  return (
    <div>
      <Hero heroData={heroData} />
      <ContactForm />
      <GhostwritingSection ghostData={ghostData} />
      <GhostCta ghostCta={ghostCta} />
      <WhyChooseSection chooseSec={chooseSec} />
      <GhostwritingWorkflow ghostWorkflow={ghostWorkflow} />
      <PortfolioSection
        titleDark="Our"
        titleHighlight="Portfolio"
        para="Our portfolio blends storytelling and design, curated works that
                reflect originality, quality, and genre spanning creativity."
      />
      <FAQSection faqs={faqs} />
    </div>
  );
};

export default BookEditingPage;
