import GhostCta from "@/components/GhostwritingPage/Cta/GhostCta";
import FAQSection from "@/components/GhostwritingPage/FAQSection/FAQSection";
import GhostwritingSection from "@/components/GhostwritingPage/GhostwritingSec/GhostwritingSec";
import GhostwritingWorkflow from "@/components/GhostwritingPage/GhostwritingWorkflow/GhostwritingWorkflow";
import Hero from "@/components/GhostwritingPage/HeroSec/Hero";
import WhyChooseSection from "@/components/GhostwritingPage/WhyChooseSec/WhyChooseSec";
import ContactForm from "@/components/landingPage/ContactForm/ContactForm";
import PortfolioSection from "@/components/landingPage/PortfolioSec/PortfolioSec";
import Image from "next/image";

export const metadata = {
  title: "eBook Marketing Services | Sell More Books Online",
  description:
    "Boost your book sales with expert eBook marketing services. Amazon, social media, SEO, and more all in one place.",
};

const heroData = {
  heading1: (
    <h1 className="hero-titles">
      <span className="hero-title-highlight">
        eBook <span className="black">Marketing Services</span> That Drive Real
        Sales
      </span>
    </h1>
  ),
  para: "Our expert eBook marketing services help you reach the right readers and grow your sales. From launch campaigns to Amazon promotions, Elume delivers results-driven strategies tailored for your book and your audience.",
};

const ghostData = {
  heading1: (
    <>
      <h1 className="ghostwriting-title-black">What Is</h1>
      <h1 className="ghostwriting-title-orange">eBook Marketing?</h1>
    </>
  ),
  para1:
    "eBook marketing is the process of promoting your digital book to attract readers and boost visibility across platforms like Amazon, Apple Books, and more. Whether you're working with an eBook marketing agency or going solo, strategic promotion is key.",
  para2:
    "At Elume, we help you build a custom plan covering how to market an eBook, increase rankings, and run targeted campaigns that convert clicks into downloads.",
  image: (
    <Image
      src="/mark1.webp"
      alt="Ghostwriting illustration"
      width={694}
      height={553}
      className="ghostwriting-image"
    />
  ),
};

const ghostCta = {
  heading1: (
    <h1 className="hero-main-title">
      From Pages to People <br />
      <span className="text-orange">Let's Promote</span> Your{" "}
      <span className="text-orange">eBook Purpose.</span>
    </h1>
  ),
  image: (
    <Image
      src="/mark2.webp"
      alt="Ghost writing promotional banner"
      width={1600}
      height={437}
      className="hero-background-image"
    />
  ),
};

const chooseSec = {
  features: (
    <ul>
      <li>We make eBook promotion easy and effective.</li>
      <li> Proven strategies for fiction and nonfiction</li>
      <li> Ideal for self-published authors</li>
      <li> Experienced ebook marketing agency support</li>
      <li>Specialists in Amazon ebook marketing</li>
      <li>Let’s put your book in front of the right readers.</li>
    </ul>
  ),

  heading1: <h2 className="why-choose-title">Why Choose Elume Publishers?</h2>,
  image: (
    <Image
      src="/mark3.webp"
      width={785}
      height={664}
      alt="Book cover showcase"
      className="book-main"
    />
  ),
};

const ghostWorkflow = {
  mainHeading: (
    <h1 className="workflow-title">
      How Our <span className="text-orange">eBook Marketing</span> Process Work?
    </h1>
  ),
  mainPara:
    "Our eBook marketing process builds visibility and sales with tailored strategies, targeted campaigns, and ongoing optimization to connect your book with the right audience across Amazon, email, and digital platforms.",

  heading1: <h3 className="step-title orange">Strategy & Positioning</h3>,
  para1:
    "We start by analyzing your book, audience, and goals. Whether you're building a brand or launching a debut, our ebook marketing services define your niche, refine your message, and develop a plan that drives engagement and visibility across digital platforms.",

  heading2: <h3 className="step-title gray">Campaign Creation & Launch</h3>,
  para2:
    "We create and manage marketing campaigns across Amazon, email, social media, and more. From Amazon ebook marketing to influencer outreach, we tailor everything to match your genre, readers, and launch goals for maximum impact and reach.",

  heading3: <h3 className="step-title orange"> Optimize & Track Results</h3>,
  para3:
    "Once launched, we monitor your campaigns and adjust for performance. With analytics-driven decisions and expert insight, our ebook marketing agency ensures your promotions are always improving turning visibility into real downloads and reviews that drive long-term success.",
};

const faqs = [
  {
    question: "What do your eBook marketing services include?",
    answer:
      "Our ebook marketing services include launch strategy, Amazon ads, email campaigns, social media promotion, and optimization designed to increase visibility, sales, and long-term reach.",
  },
  {
    question: "What’s the best way to market an eBook?",
    answer:
      "Wondering how to market an eBook? Start with Amazon ads, email lists, and reader reviews. Elume builds a full plan to help you grow and engage your ideal audience.",
  },
  {
    question: "Do you offer Amazon eBook marketing specifically?",
    answer:
      "Yes! Our Amazon ebook marketing includes keyword targeting, ad setup, and promotional pricing strategies to help your book rank higher, get noticed, and sell more copies.",
  },
  {
    question: "Is this service good for nonfiction books?",
    answer:
      "Absolutely. Our team creates tailored campaigns for all genres. Whether you wrote a novel or a digital marketing eBook, we know how to connect your content with the right readers.",
  },
  {
    question: "How long before I see results?",
    answer:
      "Marketing timelines vary, but most authors see visibility within 1–2 weeks. With ongoing optimization, our ebook marketing agency helps build sustainable growth over time not just short spikes.",
  },
];

const BookMarketingPage = () => {
  return (
    <div>
      <Hero heroData={heroData} />
      <ContactForm />
      <GhostwritingSection ghostData={ghostData} />
      <GhostCta ghostCta={ghostCta} />
      <WhyChooseSection chooseSec={chooseSec} />
      <GhostwritingWorkflow ghostWorkflow={ghostWorkflow} />
      <PortfolioSection
        titleDark="Our"
        titleHighlight="Portfolio"
        para="Our portfolio blends storytelling and design, curated works that
                reflect originality, quality, and genre spanning creativity."
      />
      <FAQSection faqs={faqs} />
    </div>
  );
};

export default BookMarketingPage;
