import GhostCta from "@/components/GhostwritingPage/Cta/GhostCta";
import FAQSection from "@/components/GhostwritingPage/FAQSection/FAQSection";
import GhostwritingSection from "@/components/GhostwritingPage/GhostwritingSec/GhostwritingSec";
import GhostwritingWorkflow from "@/components/GhostwritingPage/GhostwritingWorkflow/GhostwritingWorkflow";
import Hero from "@/components/GhostwritingPage/HeroSec/Hero";
import WhyChooseSection from "@/components/GhostwritingPage/WhyChooseSec/WhyChooseSec";
import ContactForm from "@/components/landingPage/ContactForm/ContactForm";
import PortfolioSection from "@/components/landingPage/PortfolioSec/PortfolioSec";
import Image from "next/image";

export const metadata = {
  title: "Get Promoted Book | Book Marketing & Promotions",
  description:
    " Promote your book with expert strategies. Amazon, blogs, press releases, trailers & more get your book in front of the right audience.",
};

const heroData = {
  heading1: (
    <h1 className="hero-titles">
      <span className="hero-title-highlight">
        Get <span className="black">Promoted Book</span> Campaigns That Drive
        Results
      </span>
    </h1>
  ),
  para: "Ready to get your book promoted? Elume’s expert team builds strategic campaigns to expand your reach, boost credibility, and increase sales. We help authors promote a book that deserves to be discovered.",
};

const ghostData = {
  heading1: (
    <>
      <h1 className="ghostwriting-title-black">What Is</h1>
      <h1 className="ghostwriting-title-orange">Book Promotion?</h1>
    </>
  ),
  para1:
    "Book promotion is the process of putting your work in front of the right readers through ads, features, influencer outreach, and online campaigns. Knowing how to promote your book on Amazon and beyond can boost sales and reviews fast.",
  para2:
    " At Elume, our book marketing and promotion experts craft targeted strategies that align with your genre, audience, and goals helping your book rise above the competition.",
  image: (
    <Image
      src="/pub1.webp"
      alt="Ghostwriting illustration"
      width={694}
      height={553}
      className="ghostwriting-image"
    />
  ),
};

const ghostCta = {
  heading1: (
    <h1 className="hero-main-title">
      You Wrote It <br />
      <span className="text-orange">We’ll </span> Promote It.{" "}
    </h1>
  ),
  image: (
    <Image
      src="/pro2.webp"
      alt="Ghost writing promotional banner"
      width={1600}
      height={437}
      className="hero-background-image"
    />
  ),
};

const chooseSec = {
  features: (
    <ul>
      <li>We know how to get promoted book campaigns done right.</li>
      <li>Genre-specific promotion strategies</li>
      <li>Ideal for both new and established authors</li>
      <li>Support for Amazon and off-Amazon channels</li>
      <li> Proven in book marketing and promotion</li>
      <li> Let’s boost your book’s visibility.</li>
    </ul>
  ),

  heading1: <h2 className="why-choose-title">Why Choose Elume Publishers?</h2>,
  image: (
    <Image
      src="/pro3.webp"
      width={785}
      height={664}
      alt="Book cover showcase"
      className="book-main"
    />
  ),
};

const ghostWorkflow = {
  mainHeading: (
    <h1 className="workflow-title">
      How Our <span className="text-orange">Book Promotion</span> Process Work?
    </h1>
  ),
  mainPara:
    "Our book promotion process combines strategy, targeting, and outreach helping you gain visibility, boost sales, and reach the right readers through Amazon, social media, email, and proven book marketing channels.",

  heading1: <h3 className="step-title orange">Audience & Platform Planning</h3>,
  para1:
    "We start by learning about your book, readers, and goals. Then we build a custom strategy to promote a book on Amazon, email, social platforms, or book promo sites depending on where your audience lives and buys.",

  heading2: <h3 className="step-title gray">Launch & Outreach Campaigns</h3>,
  para2:
    "From Amazon features to social ads and influencer marketing, we launch promotion campaigns that get attention. Whether you want reviews, downloads, or ranking boosts, we help you get promoted book exposure where it counts.",

  heading3: <h3 className="step-title orange">Track Results & Grow Reach</h3>,
  para3:
    "We monitor campaign performance and adjust for better results. With data-driven tweaks and feedback, your book marketing and promotion evolves helping you grow long-term visibility, reviews, and brand presence as an author.",
};

const faqs = [
  {
    question: "What’s the best way to promote a book?",
    answer:
      "Start with a targeted plan. We use ads, email, and reviews to promote a book where your ideal readers spend time especially on Amazon and social platforms.",
  },
  {
    question: "Do you offer book promotion for Amazon?",
    answer:
      "Yes! We know exactly how to promote your book on Amazon, including pricing strategies, keywords, and ad campaigns to increase rankings, reviews, and visibility.",
  },
  {
    question: "What’s the difference between book marketing and promotion?",
    answer:
      "Book marketing and promotion work together marketing builds your brand, while promotion drives attention to a specific title through campaigns, ads, and reviews.",
  },
  {
    question: "Can you help with pre-launch and post-launch promotion?",
    answer:
      "Absolutely. We help you get promoted book campaigns running both before and after release building buzz early and sustaining momentum long-term.",
  },
  {
    question: "How soon will I see results?",
    answer:
      "Most authors see visibility within 1–2 weeks. Our approach is flexible, so we adjust campaigns to improve results over time and grow your book’s reach consistently.",
  },
];

const BookPromotionPage = () => {
  return (
    <div>
      <Hero heroData={heroData} />
      <ContactForm />
      <GhostwritingSection ghostData={ghostData} />
      <GhostCta ghostCta={ghostCta} />
      <WhyChooseSection chooseSec={chooseSec} />
      <GhostwritingWorkflow ghostWorkflow={ghostWorkflow} />
      <PortfolioSection
        titleDark="Our"
        titleHighlight="Portfolio"
        para="Our portfolio blends storytelling and design, curated works that
                reflect originality, quality, and genre spanning creativity."
      />
      <FAQSection faqs={faqs} />
    </div>
  );
};

export default BookPromotionPage;
