import GhostCta from "@/components/GhostwritingPage/Cta/GhostCta";
import FAQSection from "@/components/GhostwritingPage/FAQSection/FAQSection";
import GhostwritingSection from "@/components/GhostwritingPage/GhostwritingSec/GhostwritingSec";
import GhostwritingWorkflow from "@/components/GhostwritingPage/GhostwritingWorkflow/GhostwritingWorkflow";
import Hero from "@/components/GhostwritingPage/HeroSec/Hero";
import WhyChooseSection from "@/components/GhostwritingPage/WhyChooseSec/WhyChooseSec";
import ContactForm from "@/components/landingPage/ContactForm/ContactForm";
import PortfolioSection from "@/components/landingPage/PortfolioSec/PortfolioSec";
import Image from "next/image";

export const metadata = {
  title: "Book Trailer Production | Custom Video Trailers",
  description:
    "Turn your book into a cinematic trailer. Custom video book trailers with voiceovers, editing, and publishing support across platforms.",
};

const heroData = {
  heading1: (
    <h1 className="hero-titles">
      <span className="hero-title-highlight">
        Book <span className="black">Trailer Production</span> That Captures
        Every Page
      </span>
    </h1>
  ),
  para: "Elume’s professional book trailer production services turn your story into a cinematic experience. We create high-quality video book trailers that hook viewers, boost visibility, and help your book stand out in seconds.",
};

const ghostData = {
  heading1: (
    <>
      <h1 className="ghostwriting-title-black">What Is</h1>
      <h1 className="ghostwriting-title-orange">Book Trailer?</h1>
    </>
  ),
  para1:
    "Book trailer production is the creation of short, engaging videos that promote your book visually like a movie trailer, but for your story. These trailers boost marketing impact on social media and retail platforms.",
  para2:
    "Elume offers custom trailer book production USA, complete with scripting, visuals, music, and voiceovers. We also provide book trailer editing and voiceover services for existing trailers or DIY footage, making your video truly professional.",
  image: (
    <Image
      src="/prod1.webp"
      alt="Ghostwriting illustration"
      width={694}
      height={553}
      className="ghostwriting-image"
    />
  ),
};

const ghostCta = {
  heading1: (
    <h1 className="hero-main-title">
      From Page to Trailer <br />
      <span className="text-orange">Sell </span> Your{" "}
      <span className="text-orange">Story Visually.</span>
    </h1>
  ),
  image: (
    <Image
      src="/prod2.webp"
      alt="Ghost writing promotional banner"
      width={1600}
      height={437}
      className="hero-background-image"
    />
  ),
};

const chooseSec = {
  features: (
    <ul>
      <li>We bring your book to life on screen.</li>
      <li>Full-service trailer production from script to screen</li>
      <li> Fast turnaround and affordable packages</li>
      <li>Specialized in fiction, nonfiction, and children’s books</li>
      <li> Experts in book trailer vs book promo video marketing</li>
      <li> Let’s make your story visual.</li>
    </ul>
  ),

  heading1: <h2 className="why-choose-title">Why Choose Elume Publishers?</h2>,
  image: (
    <Image
      src="/prod3.webp"
      width={785}
      height={664}
      alt="Book cover showcase"
      className="book-main"
    />
  ),
};

const ghostWorkflow = {
  mainHeading: (
    <h1 className="workflow-title">
      How Our <span className="text-orange">Book Trailer Production</span>{" "}
      Process Work?
    </h1>
  ),
  mainPara:
    "Our book trailer production process transforms your story into a visual experience with custom scripting, editing, voiceovers, and design that bring your book to life across all digital platforms.",

  heading1: <h3 className="step-title orange">Share Your Book Details</h3>,
  para1:
    "We start with your synopsis, genre, and tone. Whether you want something emotional, exciting, or educational, our book trailer production team crafts the right vision, script, and storyboard for your trailer’s tone and target audience.",

  heading2: <h3 className="step-title gray">Create, Edit, and Add Voice</h3>,
  para2:
    "We handle video creation, music selection, and book trailer editing and voiceover services. Need an animated scene, text overlay, or narrator? No problem. We bring together professional editing and high-impact visuals that fit your book’s style and message.",

  heading3: <h3 className="step-title orange">Final Trailer Delivery</h3>,
  para3:
    "Your finished video book trailer is delivered in high resolution, optimized for social media, websites, and online retailers. Whether you need a cinematic trailer or a short book promo video, Elume ensures it's ready to grab attention fast.",
};

const faqs = [
  {
    question: "What’s included in your book trailer production?",
    answer:
      "Our book trailer production includes scripting, visual editing, voiceover, music, and delivery everything needed to create a professional trailer ready for websites, Amazon, YouTube, and social media.",
  },
  {
    question:
      "What’s the difference between a book trailer and book promo video?",
    answer:
      "A book trailer is cinematic and storytelling-based, while a book promo video focuses on direct promotion. We offer both depending on your goals, audience, and preferred marketing style.",
  },
  {
    question: "Can I get voiceover and editing only?",
    answer:
      "Yes! Our book trailer editing and voiceover services are available separately if you already have footage or visuals and just need help polishing and narrating your trailer.",
  },
  {
    question: "How long should a video book trailer be?",
    answer:
      "We recommend 30–90 seconds. Our video book trailers are optimized for maximum viewer retention and designed to quickly grab attention across social and retail platforms.",
  },
  {
    question: "Do you offer custom trailer book production in the USA?",
    answer:
      "Yes! Elume offers custom trailer book production USA, serving authors nationwide with high-quality, fully customized trailers built around your story, budget, and genre.",
  },
];

const BookProductionPage = () => {
  return (
    <div>
      <Hero heroData={heroData} />
      <ContactForm />
      <GhostwritingSection ghostData={ghostData} />
      <GhostCta ghostCta={ghostCta} />
      <WhyChooseSection chooseSec={chooseSec} />
      <GhostwritingWorkflow ghostWorkflow={ghostWorkflow} />
      <PortfolioSection
        titleDark="Our"
        titleHighlight="Portfolio"
        para="Our portfolio blends storytelling and design, curated works that
                reflect originality, quality, and genre spanning creativity."
      />
      <FAQSection faqs={faqs} />
    </div>
  );
};

export default BookProductionPage;
