import GhostCta from "@/components/GhostwritingPage/Cta/GhostCta";
import FAQSection from "@/components/GhostwritingPage/FAQSection/FAQSection";
import GhostwritingSection from "@/components/GhostwritingPage/GhostwritingSec/GhostwritingSec";
import GhostwritingWorkflow from "@/components/GhostwritingPage/GhostwritingWorkflow/GhostwritingWorkflow";
import Hero from "@/components/GhostwritingPage/HeroSec/Hero";
import WhyChooseSection from "@/components/GhostwritingPage/WhyChooseSec/WhyChooseSec";
import ContactForm from "@/components/landingPage/ContactForm/ContactForm";
import PortfolioSection from "@/components/landingPage/PortfolioSec/PortfolioSec";
import Image from "next/image";

export const metadata = {
  title: "Writing Books | Professional Book Writing Services",
  description:
    "From idea to manuscript, we offer writing books services for beginners, legacy books, and all genres. Let's bring your book to life.",
};

const heroData = {
  heading1: (
    <h1 className="hero-titles">
      <span className="hero-title-highlight">
        Writing <span className="black">Books Starts Here</span> Let’s Begin
        Yours
      </span>
    </h1>
  ),
  para: "Elume Publishers makes writing books easier than ever. Whether you're starting with an idea or rough notes, our expert team helps you shape, write, and complete your story with clarity, creativity, and confidence.",
};

const ghostData = {
  heading1: (
    <>
      <h1 className="ghostwriting-title-black">What Is</h1>
      <h1 className="ghostwriting-title-orange">Book Writing?</h1>
    </>
  ),
  para1:
    "Book writing is the art of turning ideas into meaningful stories, guides, or personal journeys. Whether fiction or nonfiction, it requires structure, tone, and storytelling skills.",
  para2:
    " At Elume Publishers, our book writing services help authors at all levels including those writing a book for beginners. From concept to first draft, we support your journey with expert guidance, so you never have to write alone.",
  image: (
    <Image
      src="/bookright.webp"
      alt="Ghostwriting illustration"
      width={694}
      height={553}
      className="ghostwriting-image"
    />
  ),
};

const ghostCta = {
  heading1: (
    <h1 className="hero-main-title">
      Your Story, Our Words! <br />
      <span className="text-orange">Let's Write</span> Your{" "}
      <span className="text-orange">Legacy Together.</span>
    </h1>
  ),
  image: (
    <Image
      src="/bookCta.webp"
      alt="Ghost writing promotional banner"
      width={1600}
      height={437}
      className="hero-background-image"
    />
  ),
};

const chooseSec = {
  features: (
    <ul>
      <li>We make writing books a collaborative and creative experience.</li>
      <li>Ideal for first-time and experienced authors</li>
      <li>Personalized writing plans</li>
      <li>Support at every stage</li>
      <li>Trusted for writing and publishing a legacy book</li>
      <li>Let’s bring your story to life together.</li>
    </ul>
  ),

  heading1: <h2 className="why-choose-title">Why Choose Elume Publishers?</h2>,
  image: (
    <Image
      src="/bookleft.webp"
      width={785}
      height={664}
      alt="Book cover showcase"
      className="book-main"
    />
  ),
};

const ghostWorkflow = {
  mainHeading: (
    <h1 className="workflow-title">
      How Our <span className="text-orange">Book Writing</span> Process Work?
    </h1>
  ),
  mainPara:
    "Our book writing process turns your ideas into a powerful manuscript with step-by-step guidance, expert support, and personalized collaboration to make writing books easy, meaningful, and truly your own.",

  heading1: <h3 className="step-title orange">Share Your Story Idea</h3>,
  para1:
    "We begin by learning about your concept, goals, and voice. Whether it’s a personal journey or an expert guide, we build a clear writing plan tailored to your needs ideal for those writing a book for the first time.",

  heading2: <h3 className="step-title gray">We Write With Your Voice</h3>,
  para2:
    "Your assigned writer begins shaping the content, capturing your tone and message. We provide regular drafts, giving you full creative input. Our book writing services ensure your story remains authentic, structured, and emotionally compelling throughout the writing process.",

  heading3: <h3 className="step-title orange">Final Review and Refinement</h3>,
  para3:
    "Once your draft is complete, we refine and polish it for clarity, structure, and impact. Whether you're writing and publishing a legacy book or preparing for print, we make sure your final manuscript is ready to move forward confidently.",
};

const faqs = [
  {
    question: "How do I start writing a book?",
    answer:
      "Start with your idea, then build an outline. Elume Publishers helps simplify writing a book by guiding you step by step through the entire writing and development process.",
  },
  {
    question: "What do book writing services include?",
    answer:
      "Our book writing services include idea development, outlining, ghostwriting, revisions, and expert support making it easier for authors at any level to turn their ideas into finished books.",
  },
  {
    question: "Is writing a book for beginners possible?",
    answer:
      "Yes! Our team specializes in writing a book for beginners, providing easy-to-follow guidance, collaboration, and support to turn your first idea into a fully developed, professionally written manuscript.",
  },
  {
    question: "Can you help with writing and publishing a legacy book?",
    answer:
      "Absolutely. Elume Publishers specializes in writing and publishing a legacy book that preserves your life story or message in a powerful, lasting way for your family or the world to read.",
  },
  {
    question: "How long does it take to write a book?",
    answer:
      "The timeline varies, but most projects take 3-9 months. With Elume’s structured approach to writing books, you’ll have a dedicated writer and a clear plan from start to finish.",
  },
];

const BookWritingPage = () => {
  return (
    <div>
      <Hero heroData={heroData} />
      <ContactForm />
      <GhostwritingSection ghostData={ghostData} />
      <GhostCta ghostCta={ghostCta} />
      <WhyChooseSection chooseSec={chooseSec} />
      <GhostwritingWorkflow ghostWorkflow={ghostWorkflow} />
      <PortfolioSection
        titleDark="Our"
        titleHighlight="Portfolio"
        para="Our portfolio blends storytelling and design, curated works that
                reflect originality, quality, and genre spanning creativity."
      />
      <FAQSection faqs={faqs} />
    </div>
  );
};

export default BookWritingPage;
