import GhostCta from "@/components/GhostwritingPage/Cta/GhostCta";
import FAQSection from "@/components/GhostwritingPage/FAQSection/FAQSection";
import GhostwritingSection from "@/components/GhostwritingPage/GhostwritingSec/GhostwritingSec";
import GhostwritingWorkflow from "@/components/GhostwritingPage/GhostwritingWorkflow/GhostwritingWorkflow";
import Hero from "@/components/GhostwritingPage/HeroSec/Hero";
import WhyChooseSection from "@/components/GhostwritingPage/WhyChooseSec/WhyChooseSec";
import ContactForm from "@/components/landingPage/ContactForm/ContactForm";
import PortfolioSection from "@/components/landingPage/PortfolioSec/PortfolioSec";
import Image from "next/image";

export const metadata = {
  title: "Children’s Book Publishers | Publish Kids Books USA",
  description:
    "Work with top children's book publishers to bring your story to life. Publish your kids’ book with expert support and global reach.",
};

const heroData = {
  heading1: (
    <h1 className="hero-titles">
      <span className="hero-title-highlight">
        Children’s <span className="black">Book Publishers</span> Who Champion
        Your Story
      </span>
    </h1>
  ),
  para: "Elume Publishers helps new and experienced authors publish with ease. As trusted children’s book publishers, we guide you through editing, design, formatting, and distribution making publishing a children’s book simple and successful.",
};

const ghostData = {
  heading1: (
    <>
      <h1 className="ghostwriting-title-black">What Is</h1>
      <h1 className="ghostwriting-title-orange">Children’s Publishing?</h1>
    </>
  ),
  para1:
    "Publishing a children’s book involves more than printing it’s a journey of preparing, packaging, and promoting a story for young readers. From manuscript editing to design and distribution, publishers of children’s books help authors turn stories into shelf-ready titles.",
  para2:
    " At Elume, we combine creative vision with technical expertise to produce high-quality children’s books that resonate with readers, retailers, and schools alike perfect for both traditional and self-publishing paths.",
  image: (
    <Image
      src="/pub1.webp"
      alt="Ghostwriting illustration"
      width={694}
      height={553}
      className="ghostwriting-image"
    />
  ),
};

const ghostCta = {
  heading1: (
    <h1 className="hero-main-title">
      From Story to Shelf <br />
      <span className="text-orange">Let's Publish</span> a Book{" "}
      <span className="text-orange">That Matters.</span>
    </h1>
  ),
  image: (
    <Image
      src="/pub2.webp"
      alt="Ghost writing promotional banner"
      width={1600}
      height={437}
      className="hero-background-image"
    />
  ),
};

const chooseSec = {
  features: (
    <ul>
      <li>
        We’re more than just children’s book publishers we’re story partners.
      </li>
      <li>Expert in age-appropriate formats and layout</li>
      <li>Ideal for first-time authors</li>
      <li>Trusted as a best publisher for children’s books</li>
      <li>Wide distribution support</li>
      <li>Let’s publish your story professionally.</li>
    </ul>
  ),

  heading1: <h2 className="why-choose-title">Why Choose Elume Publishers?</h2>,
  image: (
    <Image
      src="/bookleft.webp"
      width={785}
      height={664}
      alt="Book cover showcase"
      className="book-main"
    />
  ),
};

const ghostWorkflow = {
  mainHeading: (
    <h1 className="workflow-title">
      How Our <span className="text-orange">Children’s Book Publishing</span>{" "}
      Process Work?
    </h1>
  ),
  mainPara:
    "Our children’s book publishing process guides you from manuscript to marketplace with expert editing, design, formatting, and distribution to ensure your story reaches young readers everywhere, beautifully and professionally.",

  heading1: <h3 className="step-title orange">Submit and Review</h3>,
  para1:
    "Send us your manuscript or draft. We’ll assess it for quality, age fit, and publishing potential. Whether you're refining or ready to go, we help you move forward with children’s book publishers who understand your story.",

  heading2: <h3 className="step-title gray">Edit, Design, and Format</h3>,
  para2:
    "We edit for clarity and structure, then design your layout and cover. Our team ensures your book meets all technical and visual standards from page count to typography for top publishers of children’s books and self-publishing platforms.",

  heading3: <h3 className="step-title orange">Print and Distribute</h3>,
  para3:
    "Once approved, we handle printing and distribution setup for online and bookstore platforms. Whether you're publishing a children’s book for local schools or global readers, Elume ensures it's beautifully finished, accessible, and market-ready.",
};

const faqs = [
  {
    question: " How do I start publishing a children’s book?",
    answer:
      "Submit your manuscript or idea. As expert children’s book publishers, we guide you through editing, formatting, cover design, and distribution all in one supportive, seamless process.",
  },
  {
    question: "Who are the best publishers for children's books?",
    answer:
      "The best publishers for children's books provide creative and technical support. Elume Publishers offers a complete solution tailored to first-time authors and experienced writers alike.",
  },
  {
    question: "Do you help self-publish children’s books?",
    answer:
      "Yes! We’re flexible. We assist with both traditional routes and help authors self-publish making publishing a children’s book accessible, professional, and stress-free.",
  },
  {
    question: "Do you publish all types of children's books?",
    answer:
      "Absolutely. As full-service publishers of children’s books, we work on picture books, early readers, and middle-grade titles custom-formatted for your story, theme, and target age group.",
  },
  {
    question: "How long does children’s book publishing take?",
    answer:
      "Publishing timelines vary, but most projects are completed in 4–8 weeks. Our process ensures your book is carefully edited, designed, and published without delays.",
  },
];

const BookPublicationPage = () => {
  return (
    <div>
      <Hero heroData={heroData} />
      <ContactForm />
      <GhostwritingSection ghostData={ghostData} />
      <GhostCta ghostCta={ghostCta} />
      <WhyChooseSection chooseSec={chooseSec} />
      <GhostwritingWorkflow ghostWorkflow={ghostWorkflow} />
      <PortfolioSection
        titleDark="Our"
        titleHighlight="Portfolio"
        para="Our portfolio blends storytelling and design, curated works that
                reflect originality, quality, and genre spanning creativity."
      />
      <FAQSection faqs={faqs} />
    </div>
  );
};

export default BookPublicationPage;
