import GhostCta from "@/components/GhostwritingPage/Cta/GhostCta";
import FAQSection from "@/components/GhostwritingPage/FAQSection/FAQSection";
import GhostwritingSection from "@/components/GhostwritingPage/GhostwritingSec/GhostwritingSec";
import GhostwritingWorkflow from "@/components/GhostwritingPage/GhostwritingWorkflow/GhostwritingWorkflow";
import Hero from "@/components/GhostwritingPage/HeroSec/Hero";
import WhyChooseSection from "@/components/GhostwritingPage/WhyChooseSec/WhyChooseSec";
import ContactForm from "@/components/landingPage/ContactForm/ContactForm";
import PortfolioSection from "@/components/landingPage/PortfolioSec/PortfolioSec";
import Image from "next/image";

export const metadata = {
  title: "Professional eBook Writing Services for Authors",
  description:
    "We offer professional eBook writing services that sell. From Kindle to Amazon, we help you write, format, and publish ebooks that convert.",
};

const heroData = {
  heading1: (
    <h1 className="hero-titles">
      <span className="hero-title-highlight">
        Professional <span className="black"> eBook Writing Services</span> That
        Sell Books
      </span>
    </h1>
  ),
  para: "With our professional eBook writing services, we turn your ideas into market-ready digital books. Whether you're sharing knowledge or telling a story, Elume helps you create engaging content that readers want to buy and share.",
};

const ghostData = {
  heading1: (
    <>
      <h1 className="ghostwriting-title-black">What Is</h1>
      <h1 className="ghostwriting-title-orange">eBook Writing?</h1>
    </>
  ),
  para1:
    "eBook writing involves crafting clear, valuable, and engaging content for digital readers. Whether you're writing an eBook for Amazon or growing your brand, a strong structure and compelling tone are essential.",
  para2:
    "Elume’s team handles everything from outlining to delivery. We specialize in writing eBooks that sell, helping first-time and experienced authors create content that’s polished, purposeful, and platform-ready tailored to connect with your target audience and boost your authority.",
  image: (
    <Image
      src="/ebook1.webp"
      alt="Ghostwriting illustration"
      width={694}
      height={553}
      className="ghostwriting-image"
    />
  ),
};

const ghostCta = {
  heading1: (
    <h1 className="hero-main-title">
      Your Knowledge, Our Craft
      <br />
      <span className="text-orange">Let's Write</span> an eBook{" "}
      <span className="text-orange">That Lasts.</span>
    </h1>
  ),
  image: (
    <Image
      src="/ebook2.webp"
      alt="Ghost writing promotional banner"
      width={1600}
      height={437}
      className="hero-background-image"
    />
  ),
};

const chooseSec = {
  features: (
    <ul>
      <li>Choose Elume for storytelling that stands out.</li>
      <li> Ideal for entrepreneurs, educators, and authors</li>
      <li>Custom strategy and outline support</li>
      <li>SEO-optimized content for digital platforms</li>
      <li>Experts in writing ebooks that sell</li>
      <li>We turn your message into a high-impact eBook.</li>
    </ul>
  ),

  heading1: <h2 className="why-choose-title">Why Choose Elume Publishers?</h2>,
  image: (
    <Image
      src="/ebook3.webp"
      width={694}
      height={553}
      alt="Book cover showcase"
      className="book-main"
    />
  ),
};

const ghostWorkflow = {
  mainHeading: (
    <h1 className="workflow-title">
      How Our <span className="text-orange">eBook Writing</span> Process Work?
    </h1>
  ),
  mainPara:
    "Our eBook writing process turns your ideas into compelling digital content with expert planning, collaborative writing, and revisions that ensure your eBook is polished, professional, and ready to publish or promote.",

  heading1: <h3 className="step-title orange">Discuss Your Vision</h3>,
  para1:
    "We begin by learning about your goals, audience, and topic. Whether you're launching a lead magnet or writing an eBook for Amazon, we craft a custom plan to deliver a clear, marketable message in your unique voice.",

  heading2: <h3 className="step-title gray">Writing & Collaboration</h3>,
  para2:
    "Our writers create your eBook section by section with feedback built in. You review and guide the process while we handle structure, research, tone, and flow. Our professional eBook writing services ensure quality, consistency, and clarity every step of the way.",

  heading3: <h3 className="step-title orange">Final Delivery & File Prep</h3>,
  para3:
    "After approval, we deliver a polished, publish-ready draft. Need formatting or publishing help? We’ve got you covered beyond just writing eBooks we prepare your files for Kindle, PDFs, or other platforms so you're ready to go live.",
};

const faqs = [
  {
    question: "What do professional eBook writing services include?",
    answer:
      "Our professional eBook writing services include outlining, research, writing, revisions, and content tailored for your audience ready for self-publishing, email marketing, or selling online.",
  },
  {
    question: "How do I start writing an eBook?",
    answer:
      "Start by defining your topic and audience. Elume helps you plan, outline, and write making writing an eBook easier and more strategic with expert support at every step.",
  },
  {
    question: "Can you help with writing an eBook for Amazon?",
    answer:
      "Yes! We specialize in writing an eBook for Amazon, including keyword-friendly content, formatting guidance, and delivery optimized for Kindle’s publishing requirements and reader expectations.",
  },
  {
    question: "Do you write eBooks for business or branding?",
    answer:
      "Absolutely. We’re experts at writing eBooks that sell ideal for business growth, audience engagement, or lead generation in any niche or industry.",
  },
  {
    question: "How long does it take to write an eBook?",
    answer:
      "Depending on length and complexity, eBooks take 3–8 weeks. With Elume’s efficient process, writing eBooks is smooth, collaborative, and tailored to your timeline.",
  },
];

const EbookPage = () => {
  return (
    <div>
      <Hero heroData={heroData} />
      <ContactForm />
      <GhostwritingSection ghostData={ghostData} />
      <GhostCta ghostCta={ghostCta} />
      <WhyChooseSection chooseSec={chooseSec} />
      <GhostwritingWorkflow ghostWorkflow={ghostWorkflow} />
      <PortfolioSection
        titleDark="Our"
        titleHighlight="Portfolio"
        para="Our portfolio blends storytelling and design, curated works that
                reflect originality, quality, and genre spanning creativity."
      />
      <FAQSection faqs={faqs} />
    </div>
  );
};

export default EbookPage;
