import GhostCta from "@/components/GhostwritingPage/Cta/GhostCta";
import FAQSection from "@/components/GhostwritingPage/FAQSection/FAQSection";
import GhostwritingSection from "@/components/GhostwritingPage/GhostwritingSec/GhostwritingSec";
import GhostwritingWorkflow from "@/components/GhostwritingPage/GhostwritingWorkflow/GhostwritingWorkflow";
import Hero from "@/components/GhostwritingPage/HeroSec/Hero";
import WhyChooseSection from "@/components/GhostwritingPage/WhyChooseSec/WhyChooseSec";
import ContactForm from "@/components/landingPage/ContactForm/ContactForm";
import PortfolioSection from "@/components/landingPage/PortfolioSec/PortfolioSec";
import Image from "next/image";

export const metadata = {
  title: "eBook Formatting Service | Convert PDF to eBook",
  description:
    "Professional eBook formatting service with design and layout. Format your book for Kindle, EPUB, PDF, and more.",
};

const heroData = {
  heading1: (
    <h1 className="hero-titles">
      <span className="hero-title-highlight">
        eBook<span className="black"> Formatting Service</span> That Fits Every
        Platform
      </span>
    </h1>
  ),
  para: "Our professional eBook formatting service ensures your manuscript looks perfect on every device. From layout and spacing to styling and metadata, Elume helps authors present polished, readable books across all eBook file formats.",
};

const ghostData = {
  heading1: (
    <>
      <h1 className="ghostwriting-title-black">What Is</h1>
      <h1 className="ghostwriting-title-orange">eBook Formatting?</h1>
    </>
  ),
  para1:
    "eBook formatting is the process of converting your manuscript into a clean, readable digital layout for Kindle, Apple Books, Nook, and more. It involves styling chapters, fonts, spacing, and interactive elements.",
  para2:
    "Whether you need to format an eBook from scratch or convert a print-ready file, Elume offers expert eBook formatting and design services, including PDF to eBook format conversion for seamless reading on all major platforms.",
  image: (
    <Image
      src="/format1.webp"
      alt="Ghostwriting illustration"
      width={694}
      height={553}
      className="ghostwriting-image"
    />
  ),
};

const ghostCta = {
  heading1: (
    <h1 className="hero-main-title">
      Your Story, Perfectly Formatted <br />
      <span className="text-orange">Ready </span> for{" "}
      <span className="text-orange">Every Screen.</span>
    </h1>
  ),
  image: (
    <Image
      src="/format2.webp"
      alt="Ghost writing promotional banner"
      width={1600}
      height={437}
      className="hero-background-image"
    />
  ),
};

const chooseSec = {
  features: (
    <ul>
      <li>We make formatting stress-free and professional.</li>
      <li>Compatible with all eBook file formats</li>
      <li>Ideal for self-publishing platforms</li>
      <li>Smooth PDF to eBook format conversion</li>
      <li>Trusted for quality ebook formatting and design services</li>
      <li> Let your content shine in digital form.</li>
    </ul>
  ),

  heading1: <h2 className="why-choose-title">Why Choose Elume Publishers?</h2>,
  image: (
    <Image
      src="/format3.webp"
      width={785}
      height={664}
      alt="Book cover showcase"
      className="book-main"
    />
  ),
};

const ghostWorkflow = {
  mainHeading: (
    <h1 className="workflow-title">
      How Our <span className="text-orange"> eBook Formatting</span> Process
      Work?
    </h1>
  ),
  mainPara:
    "Our eBook formatting process transforms your manuscript into a polished, platform-ready file styled, structured, and optimized for flawless display across all devices and major eBook formats like ePub, Mobi, and PDF.",

  heading1: <h3 className="step-title orange">Send Us Your File</h3>,
  para1:
    "Simply send us your manuscript in Word or PDF. We’ll assess its layout and content to plan formatting based on platform requirements and your preferences. Our eBook formatting service works with all genres and publishing goals.",

  heading2: <h3 className="step-title gray">We Format for All Devices</h3>,
  para2:
    "We clean up spacing, set styles, add metadata, and ensure readability across Kindle, ePub, and other eBook file formats. Whether you’re self-publishing or distributing widely, your book will look flawless on any screen or device.",

  heading3: (
    <h3 className="step-title orange">Deliver Ready-to-Publish Files</h3>
  ),
  para3:
    "After thorough formatting and quality checks, we deliver your final files in your chosen formats (ePub, Mobi, PDF, etc.). Whether you're converting from PDF to eBook format or launching fresh, you're ready to hit publish with confidence.",
};

const faqs = [
  {
    question: "What does your eBook formatting service include?",
    answer:
      "Our eBook formatting service includes layout design, file conversion, metadata setup, and quality checks ensuring your book displays correctly across all major eReaders and digital platforms.",
  },
  {
    question: "How do I format an eBook for Kindle or Apple?",
    answer:
      "We handle everything! Just send your manuscript and we’ll format your eBook for Kindle, Apple Books, and more with proper styling, spacing, and compatibility for every screen size.",
  },
  {
    question: "Can you convert a PDF to eBook format?",
    answer:
      "Yes! We specialize in PDF to eBook format conversion. We’ll transform your static PDF into a dynamic, responsive eBook that works perfectly on Kindle, tablets, and phones.",
  },
  {
    question: "What eBook file formats do you deliver?",
    answer:
      "We deliver files in ePub, Mobi, and PDF covering all standard eBook file formats used for Amazon KDP, Apple Books, Kobo, and other popular self-publishing platforms.",
  },
  {
    question: "What makes your formatting services different?",
    answer:
      "Our eBook formatting and design services combine technical accuracy with reader-friendly layout. We tailor every book to platform standards and your personal vision ensuring a smooth, beautiful reading experience.",
  },
];

const FormattingPage = () => {
  return (
    <div>
      <Hero heroData={heroData} />
      <ContactForm />
      <GhostwritingSection ghostData={ghostData} />
      <GhostCta ghostCta={ghostCta} />
      <WhyChooseSection chooseSec={chooseSec} />
      <GhostwritingWorkflow ghostWorkflow={ghostWorkflow} />
      <PortfolioSection
        titleDark="Our"
        titleHighlight="Portfolio"
        para="Our portfolio blends storytelling and design, curated works that
                reflect originality, quality, and genre spanning creativity."
      />
      <FAQSection faqs={faqs} />
    </div>
  );
};

export default FormattingPage;
