import GhostCta from "@/components/GhostwritingPage/Cta/GhostCta";
import FAQSection from "@/components/GhostwritingPage/FAQSection/FAQSection";
import GhostwritingSection from "@/components/GhostwritingPage/GhostwritingSec/GhostwritingSec";
import GhostwritingWorkflow from "@/components/GhostwritingPage/GhostwritingWorkflow/GhostwritingWorkflow";
import Hero from "@/components/GhostwritingPage/HeroSec/Hero";
import WhyChooseSection from "@/components/GhostwritingPage/WhyChooseSec/WhyChooseSec";
import ContactForm from "@/components/landingPage/ContactForm/ContactForm";
import PortfolioSection from "@/components/landingPage/PortfolioSec/PortfolioSec";
import Image from "next/image";

export const metadata = {
  title: "Memoir Ghostwriter | Expert Ghostwriting Services USA",
  description:
    "Hire a skilled memoir ghostwriter to bring your story to life. Professional ghostwriting services tailored for you in the USA.",
};

const heroData = {
  heading1: (
    <h1 className="hero-titles">
      <span className="hero-title-highlight">
        Hire a <span className="black">Memoir Ghostwriter</span> to Bring Your
        Story to Life
      </span>
    </h1>
  ),
  para: "Elume Publishers connects you with a skilled memoir ghostwriter who turns your life story into a powerful, emotional narrative. Our professional ghostwriter services ensure your memoir feels authentic, polished, and ready to inspire readers.",
};

const ghostData = {
  heading1: (
    <>
      <h1 className="ghostwriting-title-black">What Is</h1>
      <h1 className="ghostwriting-title-orange">Ghostwriting?</h1>
    </>
  ),
  para1:
    "Ghostwriting allows your story to be written by a skilled writer while you remain the credited author. Our expert team listens to your ideas, experiences, or notes and transforms them into a captivating narrative that reflects your unique voice.",
  para2:
    "From personal memoirs to imaginative fiction, we bring your vision to life with creativity and precision. With our ghostwriting services USA, every story is crafted to perfection authentic, engaging, and ready to inspire readers.",
  image: (
    <Image
      src="https://api.builder.io/api/v1/image/assets/TEMP/164841ebc250c61db458b196ec886a2796c53fc3?width=1388"
      alt="Ghostwriting illustration"
      width={1388}
      height={0}
      className="ghostwriting-image"
    />
  ),
};

const ghostCta = {
  heading1: (
    <h1 className="hero-main-title">
      Your Story, Our Words! <br />
      <span className="text-orange">Let's Write</span> Your{" "}
      <span className="text-orange">Legacy Together.</span>
    </h1>
  ),
  image: (
    <Image
      src="/ghostCta.webp"
      alt="Ghost writing promotional banner"
      fill
      className="hero-background-image"
    />
  ),
};

const chooseSec = {
  features: (
    <ul>
      <li>Choosing Elume Publishers means working with a team</li>
      <li>That truly values your story and voice.</li>
      <li>We match you with the right memoir ghostwriter.</li>
      <li>You stay involved throughout the process.</li>
      <li>Clear, honest communication.</li>
      <li>Skilled, passionate writers.</li>
      <li>Your story, told perfectly.</li>
    </ul>
  ),

  heading1: (
    <h2 className="why-choose-title">
      Why Choose Elume for Your Memoir Ghostwriter?
    </h2>
  ),
  image: (
    <Image
      src="/ghost.webp"
      alt="Book cover showcase"
      width={785}
      height={664}
      className="book-main"
    />
  ),
};

const ghostWorkflow = {
  mainHeading: (
    <h1 className="workflow-title">
      How Does Our <span className="text-orange">Ghostwriting Process</span>{" "}
      Work?
    </h1>
  ),
  mainPara:
    "Our memoir ghostwriter process is simple and transparent from capturing your story and drafting your book to refining every chapter, we turn your ideas into a beautifully written masterpiece.",

  heading1: <h3 className="step-title orange">Share Your Vision</h3>,
  para1:
    "We begin by understanding your story, experiences, and goals. Whether you provide notes, recordings, or simply ideas, your assigned memoir ghostwriter will listen closely to capture your unique voice and message, laying the foundation for an authentic and compelling narrative.",

  heading2: <h3 className="step-title gray">We Write, You Review</h3>,
  para2:
    " Your dedicated ghostwriter begins drafting your memoir chapter by chapter. You'll receive regular updates, giving you full control to review, approve, or suggest edits. We work closely with you to ensure every word aligns with your story, voice, and emotional tone.",

  heading3: <h3 className="step-title orange">Final Touches</h3>,
  para3:
    "Once the full draft is approved, we professionally polish your manuscript for clarity, flow, and impact. The finished book is ready for editing, publishing, or distribution all under your name, with your story told exactly the way you imagined.",
};

const faqs = [
  {
    question: "What does a memoir ghostwriter do?",
    answer:
      "A memoir ghostwriter helps you write your life story in your voice. They take your ideas, interviews, or notes and turn them into a professionally written manuscript you fully own.",
  },
  {
    question:
      "How much does it cost to hire a professional ghostwriter for a memoir?",
    answer:
      "The cost of hiring a professional ghostwriter for a memoir can range from $5,000 to $50,000 or more, depending on length, complexity, and experience of the writer.",
  },
  // {
  //   question: "Do I retain the rights to my book if I publish through Elume Publishers?",
  //   answer: "Yes, as a self-publishing service provider, Elume Publishers ensures that authors retain full rights to their books. You have complete ownership over your manuscript and published content."
  // },
  {
    question: "Are ghostwriting services legal and ethical?",
    answer:
      "Yes, ghostwriting services USA are completely legal and widely used by public figures, entrepreneurs, and everyday individuals who want to share their story but need help writing it.",
  },
  {
    question:
      "How long does it take to complete a memoir through ghostwriting?",
    answer:
      "A full memoir typically takes 4 to 12 months, depending on the depth of content and your level of involvement throughout the memoir ghostwriter process.",
  },
  {
    question: "What are the best ghostwriting services for memoirs?",
    answer:
      "The best ghostwriting services for memoirs are those that offer experienced writers, a clear process, and full confidentiality like Elume Publishers.",
  },
];

const GhostwritingPage = () => {
  return (
    <div>
      <Hero heroData={heroData} />
      <ContactForm />
      <GhostwritingSection ghostData={ghostData} />
      <GhostCta ghostCta={ghostCta} />
      <WhyChooseSection chooseSec={chooseSec} />
      <GhostwritingWorkflow ghostWorkflow={ghostWorkflow} />
      <PortfolioSection
        titleDark="Our"
        titleHighlight="Portfolio"
        para="Our portfolio blends storytelling and design, curated works that
                reflect originality, quality, and genre spanning creativity."
      />
      <FAQSection faqs={faqs} />
    </div>
  );
};

export default GhostwritingPage;
