import Link from "next/link";

export const metadata = {
  title: "Privacy Policy | Elume Publishers",
  description:
    "Your privacy matters. Learn how Elume Publishers collects, uses, and protects your information when you use our site or services.",
};

const PrivacyPolicy = () => {
  return (
    <>
      <section className="privacy-page">
        <div className="container">
          <div className="row">
            <div className="col-lg-12">
              <div className="privacy-content">
                <h1>Privacy Policy</h1>
                <p className="para">
                  {" "}
                  Elume Publishers ("we," "us," or "our") operates the website{" "}
                  <Link href={"/"}>https://elumepublishers.com</Link> (the
                  "Site"). This Privacy Policy outlines our practices regarding
                  the collection, use, and disclosure of personal information
                  when you use our Site and services.
                </p>

                <div className="privacy-content-box">
                  <h3>1. Information We Collect</h3>
                  <p className="para">
                    We may collect the following types of information:
                  </p>
                  <ul>
                    <li>
                      <b>Personal Information:</b> Name, email address, phone
                      number, mailing address, and other contact details.
                    </li>
                    <li>
                      <b>Payment Information:</b> Billing details necessary for
                      processing transactions.
                    </li>
                    <li>
                      <b>Content Information:</b> Manuscripts, documents, or
                      other materials you submit for our services.
                    </li>
                    <li>
                      <b>Usage Data:</b> Information on how you access and use
                      the Site, including IP address, browser type, and browsing
                      behavior.
                    </li>
                  </ul>
                </div>
                <div className="privacy-content-box">
                  <h3>2. How We Use Your Information</h3>
                  <p className="para">We use the collected information to:</p>
                  <ul>
                    <li>Provide and maintain our services.</li>
                    <li>Process transactions and send related information.</li>
                    <li>
                      Communicate with you, including responding to inquiries
                      and providing customer support.
                    </li>
                    <li>Improve our Site and services.</li>
                    <li>
                      Send promotional communications, subject to your
                      preferences.
                    </li>
                  </ul>
                </div>
                <div className="privacy-content-box">
                  <h3>3. Sharing Your Information</h3>
                  <p className="para">
                    We do not sell or rent your personal information. We may
                    share your information with:
                  </p>
                  <ul>
                    <li>
                      <b>Service Providers:</b> Third parties who perform
                      services on our behalf, such as payment processing and
                      marketing.
                    </li>
                    <li>
                      <b>Legal Requirements:</b> If required by law or in
                      response to valid requests by public authorities.
                    </li>
                  </ul>
                </div>
                <div className="privacy-content-box">
                  <h3>4. Data Security</h3>
                  <p className="para">
                    We implement appropriate technical and organizational
                    measures to protect your personal information against
                    unauthorized access, alteration, disclosure, or destruction.
                  </p>
                </div>
                <div className="privacy-content-box">
                  <h3>5. Your Rights</h3>
                  <p className="para">
                    Depending on your location, you may have the following
                    rights regarding your personal information:
                  </p>
                  <ul>
                    <li>Access the personal information we hold about you.</li>
                    <li>
                      Request correction or deletion of your personal
                      information.
                    </li>
                    <li>
                      Object to or restrict our processing of your personal
                      information.
                    </li>
                    <li>
                      Withdraw consent at any time, where processing is based on
                      consent.
                    </li>
                  </ul>
                  <p className="para">
                    To exercise these rights, please contact us at
                    info@elumepublishers.com.
                  </p>
                </div>
                <div className="privacy-content-box">
                  <h3>6. Cookies and Tracking Technologies</h3>
                  <p className="para">
                    Our Site may use cookies and similar tracking technologies
                    to enhance user experience. You can set your browser to
                    refuse cookies, but some features of the Site may not
                    function properly without them.
                  </p>
                </div>
                <div className="privacy-content-box">
                  <h3>7. Third-Party Links</h3>
                  <p className="para">
                    Our Site may contain links to third-party websites. We are
                    not responsible for the privacy practices or content of
                    these external sites.
                  </p>
                </div>
                <div className="privacy-content-box">
                  <h3>8. Children's Privacy</h3>
                  <p className="para">
                    Our services are not directed to individuals under the age
                    of 13. We do not knowingly collect personal information from
                    children under 13.
                  </p>
                </div>
                <div className="privacy-content-box">
                  <h3>9. Changes to This Privacy Policy</h3>
                  <p className="para">
                    We may update this Privacy Policy from time to time. We will
                    notify you of any changes by posting the new policy on this
                    page with an updated effective date.
                  </p>
                </div>
                <div className="privacy-content-box">
                  <h3>10. Contact Us</h3>
                  <p className="para">
                    If you have any questions about this Privacy Policy, please
                    contact us:
                  </p>
                  <p className="para">Elume Publishers</p>
                  <p className="para">119 S Western Ave Unit 1 #238</p>
                  <p className="para">Chicago, IL 60612</p>
                  <p className="para">
                    Email:{" "}
                    <Link href={"mailto:info@elumepublishers.com"}>
                      info@elumepublishers.com
                    </Link>
                  </p>
                  <p className="para">
                    Phone: <Link href={"tel:12179069606"}>+1 (217) 906 9606</Link>
                  </p>
                </div>
              </div>
            </div>
          </div>
        </div>
      </section>
    </>
  );
};

export default PrivacyPolicy;
