import GhostCta from "@/components/GhostwritingPage/Cta/GhostCta";
import FAQSection from "@/components/GhostwritingPage/FAQSection/FAQSection";
import GhostwritingSection from "@/components/GhostwritingPage/GhostwritingSec/GhostwritingSec";
import GhostwritingWorkflow from "@/components/GhostwritingPage/GhostwritingWorkflow/GhostwritingWorkflow";
import Hero from "@/components/GhostwritingPage/HeroSec/Hero";
import WhyChooseSection from "@/components/GhostwritingPage/WhyChooseSec/WhyChooseSec";
import ContactForm from "@/components/landingPage/ContactForm/ContactForm";
import PortfolioSection from "@/components/landingPage/PortfolioSec/PortfolioSec";
import Image from "next/image";

export const metadata = {
  title: "Best Proofreading Service | Book Editing Experts",
  description:
    "Get the best proofreading service for your book. Clear, error-free content with expert editing and formatting for publishing success.",
};

const heroData = {
  heading1: (
    <h1 className="hero-titles">
      <span className="hero-title-highlight">
        Best <span className="black">Proofreading Service</span> to Perfect Your
        Manuscript
      </span>
    </h1>
  ),
  para: "Our best proofreading service catches every error before publishing. From grammar and punctuation to clarity and flow, Elume Publishers ensures your book reads professionally giving authors peace of mind and polished perfection.",
};

const ghostData = {
  heading1: (
    <>
      <h1 className="ghostwriting-title-black">What Is</h1>
      <h1 className="ghostwriting-title-orange">Proofreading?</h1>
    </>
  ),
  para1:
    "Proofreading is the final step in the editing process, focusing on surface-level errors like grammar, spelling, punctuation, and formatting. It ensures your book is clean, consistent, and ready to publish.",
  para2:
    "Elume Publishers offers both editing and proofreading to suit your manuscript’s needs. Whether you’re preparing for self-publishing or submission, our team delivers the best book editing and proofreading services to help your words shine without distraction.",
  image: (
    <Image
      src="/proof1.webp"
      alt="Ghostwriting illustration"
      width={694}
      height={553}
      className="ghostwriting-image"
    />
  ),
};

const ghostCta = {
  heading1: (
    <h1 className="hero-main-title">
      Your Words, Refined <br />
      <span className="text-orange">Let’s Perfect</span> Your{" "}
      <span className="text-orange">Legacy Together.</span>
    </h1>
  ),
  image: (
    <Image
      src="/proof2.webp"
      alt="Ghost writing promotional banner"
      width={1600}
      height={437}
      className="hero-background-image"
    />
  ),
};

const chooseSec = {
  features: (
    <ul>
      <li>Choose Elume for quality and accuracy.</li>
      <li>Trusted by first-time and experienced authors</li>
      <li>Careful, detail-focused proofreading</li>
      <li>Transparent, collaborative process</li>
      <li>Experts in proofreading vs copy editing needs</li>
      <li> We make sure your final draft is flawless and professional.</li>
    </ul>
  ),

  heading1: <h2 className="why-choose-title">Why Choose Elume Publishers?</h2>,
  image: (
    <Image
      src="/proof3.webp"
      width={785}
      height={664}
      alt="Book cover showcase"
      className="book-main"
    />
  ),
};

const ghostWorkflow = {
  mainHeading: (
    <h1 className="workflow-title">
      How Our <span className="text-orange">Proofreading Process</span> Work?
    </h1>
  ),
  mainPara:
    "Our proofreading process ensures your manuscript is error-free with expert review, precise corrections, and final polishing that guarantees clarity, consistency, and confidence before your book goes to print or digital release.",

  heading1: <h3 className="step-title orange">Share Your Final Draft</h3>,
  para1:
    "Upload your manuscript, and we’ll match it with a proofreader who understands your genre and voice. Whether you're finalizing fiction or nonfiction, our best proofreading service ensures your content is polished and publication-ready.",

  heading2: <h3 className="step-title gray">Precision Proofreading</h3>,
  para2:
    "Your proofreader checks for grammar, punctuation, spelling, and typographical errors the last layer of polish before publishing. Our team combines human expertise and quality checks to ensure every word meets professional standards.",

  heading3: <h3 className="step-title orange">Final File Delivery</h3>,
  para3:
    "After proofreading is complete, we deliver a clean, corrected manuscript. If needed, we’ll explain the difference between proofreading vs copy editing, so you understand exactly what was done and how your book is now ready for release.",
};

const faqs = [
  {
    question: " What does a proofreading service include?",
    answer:
      "Our proofreading service checks for grammar, punctuation, typos, and formatting issues  offering the final polish your manuscript needs before publication or submission.",
  },
  {
    question: "What’s the difference between editing and proofreading?",
    answer:
      "Editing improves flow and structure, while proofreading corrects surface-level mistakes. Not sure? We’ll guide you on proofreading vs copy editing based on your manuscript’s stage.",
  },
  {
    question: "Do I need both editing and proofreading?",
    answer:
      "Yes, most books benefit from editing and proofreading. Editing shapes your content; proofreading catches last-minute errors. Elume offers both, depending on your book’s readiness.",
  },
  {
    question: "Who provides the best proofreading service?",
    answer:
      "Elume Publishers is known for its best proofreading service, combining experienced editors, attention to detail, and author collaboration to ensure your manuscript is 100% error-free.",
  },
  {
    question: "How long does proofreading take?",
    answer:
      "Turnaround varies by length and complexity, but most proofreading projects are completed within 1–2 weeks. We work efficiently to deliver high-quality results on time.",
  },
];

const ProofreadingPage = () => {
  return (
    <div>
      <Hero heroData={heroData} />
      <ContactForm />
      <GhostwritingSection ghostData={ghostData} />
      <GhostCta ghostCta={ghostCta} />
      <WhyChooseSection chooseSec={chooseSec} />
      <GhostwritingWorkflow ghostWorkflow={ghostWorkflow} />
      <PortfolioSection
        titleDark="Our"
        titleHighlight="Portfolio"
        para="Our portfolio blends storytelling and design, curated works that
                reflect originality, quality, and genre spanning creativity."
      />
      <FAQSection faqs={faqs} />
    </div>
  );
};

export default ProofreadingPage;
