import React from "react";

import "./Hero.css";

const Hero = () => {
  return (
    <section className="hero-whoweare">
      <div className="hero-bg-pattern"></div>

      <div className="container">
        <div className="row align-items-center">
          {/* Left Content Column */}
          <div className="col-12 col-lg-6 mb-4 mb-lg-0">
            <h1 className="hero-heading">Who We Are</h1>
            <p className="hero-text">
              Our aim is to guide authors through every step of their publishing
              work. We have professionals to transform ideas and manuscripts
              into powerful, professional books that inspire readers worldwide.
              With a team of experienced writers, editors, designers, and
              marketers, we blend creativity with strategy to ensure your story
              leaves a lasting impact.
            </p>
            <button
              className="btn-hero-quote"
              data-bs-toggle="modal"
              data-bs-target="#couponModal"
            >
              <div className="btn-circles">
                <span className="circle circle-1"></span>
                <span className="circle circle-2"></span>
                <span className="circle circle-3"></span>
                <span className="circle circle-4"></span>
              </div>
              <span className="btn-text">Request a Quote</span>
            </button>
          </div>
        </div>
      </div>
    </section>
  );
};

export default Hero;
