import React from "react";
import "./GhostwritingSec.css";

function GhostwritingSection({ ghostData }) {
  return (
    <section className="ghostwriting-section">
      <div className="container">
        <div className="row">
          <div className="col-12">
            <div className="ghostwriting-wrapper">
              <div className="row align-items-center">
                <div className="col-12 col-lg-6">
                  <article className="ghostwriting-content">
                    <header className="ghostwriting-header">
                      {ghostData.heading1}
                    </header>
                    <div className="ghostwriting-text">
                      <p>{ghostData.para1}</p>
                      <p>{ghostData.para2}</p>
                    </div>
                  </article>
                </div>

                <div className="col-12 col-lg-6">
                  <div className="ghostwriting-image-wrapper">
                    {ghostData.image}
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
  );
}

export default GhostwritingSection;
