import React from "react";
import "./GhostwritingWorkflow.css";
import Image from "next/image";

const GhostwritingWorkflow = ({ ghostWorkflow }) => {
  return (
    <section className="ghostwriting-workflow">
      <div className="container">
        <div className="row">
          <div className="col-12">
            <div className="workflow-wrapper">
              <div className="workflow-content">
                <div className="row">
                  <div className="col-12">
                    <header className="workflow-header">
                      {ghostWorkflow.mainHeading}
                      <p className="workflow-description">
                        {ghostWorkflow.mainPara}
                      </p>
                    </header>
                  </div>
                </div>

                <div className="row workflow-step">
                  <div className="col-12 col-lg-5 col-md-6">
                    <div className="step-number-card">
                      <Image
                        src="/ghost1.webp"
                        className="step-card-background"
                        width={472}
                        height={274}
                        alt=""
                      />
                    </div>
                  </div>
                  <div className="col-12 col-lg-7 col-md-6">
                    <div className="step-content">
                      {ghostWorkflow.heading1}
                      <p className="step-text">{ghostWorkflow.para1}</p>
                    </div>
                  </div>
                </div>

                <div className="row workflow-step">
                  <div className="col-12 col-lg-7 order-lg-1 order-2  col-md-6">
                    <div className="step-content">
                      {ghostWorkflow.heading2}
                      <p className="step-text">{ghostWorkflow.para2}</p>
                    </div>
                  </div>
                  <div className="col-12 col-lg-5 order-lg-2 order-1  col-md-6">
                    <div className="step-number-card">
                      <Image
                        src="/ghost2.webp"
                        className="step-card-background"
                        width={472}
                        height={274}
                        alt=""
                      />
                    </div>
                  </div>
                </div>

                <div className="row workflow-step">
                  <div className="col-12 col-lg-5  col-md-6">
                    <div className="step-number-card">
                      <Image
                        src="/ghost3.webp"
                        className="step-card-background"
                        width={472}
                        height={274}
                        alt=""
                      />
                    </div>
                  </div>
                  <div className="col-12 col-lg-7 col-md-6">
                    <div className="step-content">
                      {ghostWorkflow.heading3}
                      <p className="step-text">{ghostWorkflow.para3}</p>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
  );
};

export default GhostwritingWorkflow;
