"use client";
import React from "react";
import "./ServiceSec.css";
import Image from "next/image";
import { FiArrowUpRight } from "react-icons/fi";

const ServiceCard = ({ icon, title, description }) => {
  return (
    <div className="service-card-wrapper">
      <div className="service-icon-container">
        <Image
          src={icon}
          width={100}
          height={101}
          alt={`${title} icon`}
          className="service-icon"
        />
      </div>
      <div className="service-card-content">
        <div className="service-card-inner">
          <h3 className="service-title">{title}</h3>
          <p className="service-description">{description}</p>
          <button
            className="service-btn"
            data-bs-toggle="modal"
            data-bs-target="#couponModal"
          >
            <div className="service-btn-content">
              <span className="service-btn-text">Get a Quote</span>
               <FiArrowUpRight className="service-btn-arrow" />
            </div>
          </button>
        </div>
      </div>
    </div>
  );
};

const ServiceSec = () => {
  const services = [
    {
      icon: "https://api.builder.io/api/v1/image/assets/15161154b48645df88fb0490ee5cc09b/cb95e8c45b9e69b5175cad580c74c2e301432663?placeholderIfAbsent=true",
      title: "Book Publishing",
      description:
        "We manage the entire publishing process from formatting and cover design on platforms. Our experts ensure the book meets industry standards, reaches the right audience, and stands out in a market.",
    },
    {
      icon: "/icon1.webp",
      title: "Book Writing",
      description:
        "Our professional book writing service turns your ideas into compelling manuscripts. Whether it's fiction or nonfiction, we craft original content tailored to your voice, goals, and target audience.",
    },
    {
      icon: "https://api.builder.io/api/v1/image/assets/15161154b48645df88fb0490ee5cc09b/82a842b57f0a9310313a09acc29fcdb06e89dd20?placeholderIfAbsent=true",
      title: "Ghostwriting",
      description:
        "Our professional book writing service transforms your ideas into compelling manuscripts, crafting original fiction or nonfiction tailored to your voice, goals, and specific target audience.",
    },
    {
      icon: "https://api.builder.io/api/v1/image/assets/15161154b48645df88fb0490ee5cc09b/2b6d5daa33fd89a804c102eeca16d5d2a57c7d28?placeholderIfAbsent=true",
      title: "Book Editing",
      description:
        "Our experienced editors enhance your manuscript’s grammar, structure, tone, and flow improving readability while preserving your unique voice to ensure it’s polished and ready for publication.",
    },
    {
      icon: "/icon2.webp",
      title: "Proofreading Services",
      description:
        "Your words matter let’s make them shine. Our expert proofreaders polish every sentence for clarity and accuracy, ensuring your book is flawless, professional, and ready for global publishing success.",
    },
    {
      icon: "/icon3.webp",
      title: "Formatting Services",
      description:
        "We professionally format your manuscript with clean structure, consistent styling, and perfect alignment ensuring it looks sharp, polished, and ready for flawless viewing on print and digital platforms.",
    },
    {
      icon: "/icon4.webp",
      title: "Ebook Writing",
      description:
        "Bring your story to life with our ebook writing service. We create original, structured digital books tailored to your voice, genre, and audience, professionally crafted and prepared for global publication.",
    },
    {
      icon: "https://api.builder.io/api/v1/image/assets/15161154b48645df88fb0490ee5cc09b/22768df74ebd424a40afce6951382d4775fd378f?placeholderIfAbsent=true",
      title: "Audio Book Recording",
      description:
        "Expand your audience with professional audiobook services. From narration to sound design, we create high-quality audio versions that engage listeners across all major platforms.",
    },
    {
      icon: "/icon5.webp",
      title: "Book Cover Design",
      description:
        "Make your book stand out with our affordable ebook cover design. We create stunning, genre specific covers that reflect your story and attract readers on digital and print platforms.",
    },
    {
      icon: "/icon12.webp",
      title: "Children's Book Writing",
      description:
        "Our team of writers, illustrators, and designers specializes in creating books for young readers. We combine captivating stories with vibrant visuals to educate, entertain, and inspire children.",
    },
    {
      icon: "/icon6.webp",
      title: "Children's Book Publication",
      description:
        "Partner with experienced children’s book publishers who understand young minds. We help you publish engaging, age-appropriate stories that educate, inspire, and entertain kids worldwide.",
    },
    {
      icon: "/icon7.webp",
      title: "Children's Book Illustrations",
      description:
        "Our illustration services blend playful visuals and storytelling, bringing characters to life with custom artwork that captivates children’s imaginations and suits your story, theme, and audience.",
    },

    {
      icon: "https://api.builder.io/api/v1/image/assets/15161154b48645df88fb0490ee5cc09b/ebf78c1309ca9784d8a98f3521e6e850a64deb04?placeholderIfAbsent=true",
      title: "Book Marketing",
      description:
        "Maximize your book’s reach with strategic marketing. From social media and press releases to blogs and book trailers, we boost visibility, attract readers, and drive sales where it matters most.",
    },
    {
      icon: "/icon8.webp",
      title: "Book Promotion",
      description:
        "Want your story to shine? Our creative strategies deliver standout book exposure through buzz worthy campaigns, genuine reader engagement, and smart visibility that puts your book in the spotlight.",
    },
    {
      icon: "/icon9.webp",
      title: "Author Marketing",
      description:
        "We promote authors through strategic branding, targeted engagement, and customized plans helping you grow your audience, stand out in your genre, and connect with readers who truly value.",
    },
    {
      icon: "https://api.builder.io/api/v1/image/assets/15161154b48645df88fb0490ee5cc09b/f98974e93f00b00e9dea26dbe1d31b1b836873be?placeholderIfAbsent=true",
      title: "Book Trailer Production",
      description:
        "Capture attention and spark excitement with cinematic book trailers. Animated or live-action, our trailers showcase your story’s essence and engage audiences across all major digital platforms.",
    },
    {
      icon: "/icon2.webp",
      title: "Book Printing",
      description:
        "Whether you need on-demand copies or large-scale production, we make it easy to print a book with precision. Our high-quality printing ensures every copy feels premium and reader-worthy.",
    },
    {
      icon: "/icon10.webp",
      title: "Article Writing & Publishing",
      description:
        "Boost your brand with expert article writing. We create SEO-optimized, compelling content and publish on high-authority platforms to build credibility and reach your ideal audience effectively.",
    },
    {
      icon: "/icon11.webp",
      title: "Blog Writing",
      description:
        "Grow your brand with our expert blog writing service. We deliver strategic, SEO-rich content tailored to your industry, boosting visibility, driving traffic, and engaging readers with every post.",
    },
    {
      icon: "/icon12.webp",
      title: "Web Content Writing",
      description:
        "Make every word count with expert website content writing that connects, converts, and ranks. We craft clear, on-brand content that builds trust and boosts your online performance.",
    },
    {
      icon: "/icon13.webp",
      title: "Business Proposal Writing",
      description:
        "Gain more opportunities with our expert proposal writing services. We craft clear, persuasive proposals that impress clients, attract investors, and help grow your business with confidence.",
    },
    {
      icon: "https://api.builder.io/api/v1/image/assets/15161154b48645df88fb0490ee5cc09b/eb2a9d2daf447dd86474c15096869121aaecf788?placeholderIfAbsent=true",
      title: "Author Website Design",
      description:
        "Build your online presence with our author website design services. We create custom, user-friendly websites that showcase your books, reflect your brand, and grow your audience.",
    },
    {
      icon: "/icon14.webp",
      title: "Translations",
      description:
        "Break language barriers with confidence. Our expert legal translation services ensure your contracts, policies, and documents are crystal clear, culturally accurate, and ready for the global stage.",
    },
  ];

  return (
    <>
      <section className="services-mains">
        {/* Top Background Image */}
        <div className="services-background services-background-top">
          <Image
            src="/top.webp"
            alt="Background Top"
            width={1860}
            height={668}
            className="services-bg-image"
          />
        </div>

        {/* Bottom Background Image */}
        <div className="services-background services-background-bottom">
          <Image
            src="https://api.builder.io/api/v1/image/assets/15161154b48645df88fb0490ee5cc09b/2cdc38d14e5b9b6cf8ec6db182ed5960261b0a4d?placeholderIfAbsent=true"
            alt="Background Bottom"
            width={1860}
            height={668}
            className="services-bg-image"
          />
        </div>

        <div className="container">
          <div className="row justify-content-center">
            <div className="col-12">
              {/* Header Section */}
              <div className="row justify-content-center">
                <div className="col-lg-12 col-md-12">
                  <div className="services-header text-center">
                    <h2 className="services-title">
                      Our{" "}
                      <span className="services-title-highlight">
                        Core Services
                      </span>
                    </h2>
                    <p className="services-subtitle">
                      We provide a complete range of professional publishing
                      solutions designed to transform ideas into impactful,
                      market-ready books. We make the publishing process
                      seamless, strategic, and successful.
                    </p>
                  </div>
                </div>
              </div>

              {/* Services Grid */}
              <div className="row justify-content-center services-grid">
                {services.map((service, index) => (
                  <div key={index} className="col-lg-4 col-md-6 col-12">
                    <ServiceCard {...service} />
                  </div>
                ))}
              </div>
            </div>
          </div>
        </div>
      </section>
    </>
  );
};

export default ServiceSec;
