"use client";
import React, { useEffect, useState } from "react";
import Link from "next/link";
import "./Header.css";
import { usePathname } from "next/navigation";
import { ChevronDown } from "lucide-react";
import Image from "next/image";

const Header = () => {
  const [isMenuOpen, setIsMenuOpen] = useState(false);
  const [isServicesOpen, setIsServicesOpen] = useState(false);
  const [isMobileServicesOpen, setIsMobileServicesOpen] = useState(false);
  const pathname = usePathname();

  const toggleMenu = () => {
    setIsMenuOpen(!isMenuOpen);
    setIsMobileServicesOpen(false);
  };

  useEffect(() => {
    setIsServicesOpen(false);
    setIsMenuOpen(false);
    setIsMobileServicesOpen(false);
  }, [pathname]);

  const toggleMobileServices = (e) => {
    e.preventDefault();
    e.stopPropagation();
    setIsMobileServicesOpen(!isMobileServicesOpen);
  };

  return (
    <>
      <header className="header-container">
        <div className="container-xxl">
          <div className="row align-items-center justify-content-between">
            <div className="col-lg-3 col-md-4 col-sm-6 col-8">
              <Link href="/">
                <Image
                  src="https://api.builder.io/api/v1/image/assets/TEMP/7f358d633dc0a2971a4c5e0349f16c26b54f18a8?width=468"
                  alt="Elume Publisher Logo"
                  width={500}
                  height={400}
                  className="logo-img"
                />
              </Link>
            </div>

            <div className="col-lg-6 col-md-4 d-none d-lg-flex justify-content-center">
              <nav className="nav-container">
                <Link
                  href="/"
                  className={pathname === "/" ? "nav-item-active" : "nav-item"}
                >
                  <span
                    className={
                      pathname === "/" ? "nav-text-active" : "nav-text"
                    }
                  >
                    Home
                  </span>
                </Link>

                <Link
                  href="/about-us"
                  className={
                    pathname === "/about-us" ? "nav-item-active" : "nav-item"
                  }
                >
                  <span
                    className={
                      pathname === "/about-us" ? "nav-text-active" : "nav-text"
                    }
                  >
                    About us
                  </span>
                </Link>

                <div
                  className={`services-dropdown-wrapper ${
                    pathname === "/services" ? "nav-item-active" : "nav-item"
                  }`}
                  onMouseEnter={() => setIsServicesOpen(true)}
                  onMouseLeave={() => setIsServicesOpen(false)}
                >
                  <Link href="/services" className="services-link">
                    <span
                      className={`flex items-center gap-1 ${
                        pathname === "/services"
                          ? "nav-text-active"
                          : "nav-text"
                      }`}
                    >
                      Services
                      <ChevronDown
                        className={`dropdown-arrow transition-transform duration-300 ${
                          isServicesOpen ? "rotate-180" : ""
                        }`}
                        size={16}
                      />
                    </span>
                  </Link>
                  <div
                    className={`services-dropdown ${
                      isServicesOpen ? "show" : ""
                    }`}
                  >
                    <div className="row">
                      <div className="col-lg-3 col-md-12">
                        <div className="promo-section">
                          <h2>Launch Your Book</h2>
                          <p>50% Discount</p>
                          <Image
                            src="https://api.builder.io/api/v1/image/assets/TEMP/9138f5ff611439dd25a6a36090e72cb24e4c8dd3?width=452"
                            alt="Book publishing illustration"
                            width={500}
                            height={400}
                          />

                          <Link href={"tel:12179069606"}>
                            <button className="promo-btn">
                              <svg
                                width="20"
                                height="20"
                                viewBox="0 0 29 29"
                                fill="none"
                              >
                                <path
                                  d="M26.513 20.1969V24.7544C26.5131 25.0807 26.3851 25.3949 26.1547 25.6337C25.9243 25.8724 25.6087 26.0179 25.2715 26.0407C24.6887 26.0802 24.2126 26.1 23.8433 26.1C12.0472 26.1 2.48572 16.8677 2.48572 5.47777C2.48572 5.12204 2.50619 4.66234 2.54712 4.09866C2.57078 3.77314 2.72143 3.46841 2.96867 3.24594C3.21591 3.02348 3.54134 2.89985 3.8793 2.89999H8.59931C8.76489 2.89983 8.92461 2.9591 9.04746 3.06629C9.17031 3.17347 9.24751 3.32092 9.26407 3.47999C9.29432 3.77558 9.3228 4.01273 9.3495 4.19146C9.61476 5.97905 10.1584 7.71765 10.962 9.34831C11.0888 9.60608 11.006 9.91413 10.7658 10.0791L7.88517 12.0666C9.64679 16.029 12.9172 19.1868 17.0209 20.8877L19.0765 18.1115C19.1602 17.9976 19.2828 17.916 19.4227 17.8808C19.5626 17.8457 19.7109 17.8594 19.8414 17.9194C21.53 18.6939 23.3301 19.2175 25.1808 19.4725C25.3659 19.4983 25.6106 19.5258 25.9149 19.555C26.0794 19.5713 26.2318 19.646 26.3426 19.7646C26.4533 19.8832 26.5132 20.0372 26.513 20.1969Z"
                                  fill="white"
                                />
                              </svg>
                              Call Now!
                            </button>
                          </Link>
                        </div>
                      </div>

                      <div className="col-lg-4 col-md-6">
                        <h3 className="dropdown-section-title">Services</h3>
                        <div className="row">
                          <div className="col-6">
                            <div className="dropdown-column">
                              <ul>
                                <li>
                                  <Link href="/book-publishing">
                                    Book Publishing
                                  </Link>
                                </li>
                                <li>
                                  <Link href="/book-writing">Book Writing</Link>
                                </li>
                                <li>
                                  <Link href="/ghostwriting">Ghostwriting</Link>
                                </li>
                                <li>
                                  <Link href="/book-editing">Book Editing</Link>
                                </li>
                                <li>
                                  <Link href="/proofreading-services">
                                    Proofreading Services
                                  </Link>
                                </li>
                                <li>
                                  <Link href="/formatting-services">
                                    Formatting Services
                                  </Link>
                                </li>
                                <li>
                                  <Link href="/ebook-writing">
                                    Ebook Writing
                                  </Link>
                                </li>
                                <li>
                                  <Link href="/audio-book-recording">
                                    Audio Book Recording
                                  </Link>
                                </li>
                                <li>
                                  <Link href="/book-cover-design">
                                    Book Cover Design
                                  </Link>
                                </li>
                                <li>
                                  <Link href="/children-book-writing">
                                    Children's Book Writing
                                  </Link>
                                </li>
                                <li>
                                  <Link href="/children-book-publication">
                                    Children's Book Publication
                                  </Link>
                                </li>
                                <li>
                                  <Link href="/children-book-illustrations">
                                    Children's Book Illustrations
                                  </Link>
                                </li>
                              </ul>
                            </div>
                          </div>
                          <div className="col-6">
                            <div className="dropdown-column">
                              <ul>
                                <li>
                                  <Link href="/book-marketing">
                                    Book Marketing
                                  </Link>
                                </li>
                                <li>
                                  <Link href="/book-promotion">
                                    Book Promotion
                                  </Link>
                                </li>
                                <li>
                                  <Link href="/author-marketing">
                                    Author Marketing
                                  </Link>
                                </li>
                                <li>
                                  <Link href="/book-trailer-production">
                                    Book Trailer Production
                                  </Link>
                                </li>
                                <li>
                                  <Link href="/book-printing">
                                    Book Printing
                                  </Link>
                                </li>
                                <li>
                                  <Link href="/article-writing-and-publishing">
                                    Article Writing & Publishing
                                  </Link>
                                </li>
                                <li>
                                  <Link href="/blog-writing">Blog Writing</Link>
                                </li>
                                <li>
                                  <Link href="/web-content-writing">
                                    Web Content Writing
                                  </Link>
                                </li>
                                <li>
                                  <Link href="/business-proposal-writing">
                                    Business Proposal Writing
                                  </Link>
                                </li>
                                <li>
                                  <Link href="/author-website-design">
                                    Author Website Design
                                  </Link>
                                </li>
                                <li>
                                  <Link href="/translations">Translations</Link>
                                </li>
                              </ul>
                            </div>
                          </div>
                        </div>
                      </div>

                      <div className="col-lg-auto d-none d-lg-block">
                        <div
                          className="divider"
                          style={{ height: "100%" }}
                        ></div>
                      </div>

                      <div className="col-lg-5 col-md-6">
                        <h3 className="dropdown-section-title">Genres</h3>

                        <div className="row">
                          <div className="col-4">
                            <div className="dropdown-column">
                              <h3>Fiction Genres</h3>
                              <ul>
                                <li>Literary Fiction</li>
                                <li>Historical Fiction</li>
                                <li>Romance</li>
                                <li>Mystery / Thriller / Suspense</li>
                                <li>Science Fiction (Sci-Fi)</li>
                                <li>Fantasy</li>
                                <li>Adventure</li>
                                <li>Horror</li>
                                <li>Young Adult (YA) Fiction</li>
                                <li>Children's Fiction</li>
                              </ul>
                            </div>
                          </div>
                          <div className="col-4">
                            <div className="dropdown-column">
                              <h3>Non-Fiction Genres</h3>
                              <ul>
                                <li>Biographies & Memoirs</li>
                                <li>Self-Help & Personal Development</li>
                                <li>Business & Entrepreneurship</li>
                                <li>Health, Wellness & Fitness</li>
                                <li>History & Politics</li>
                                <li>Travel & Adventure</li>
                                <li>True Crime</li>
                                <li>Science & Technology</li>
                                <li>Education & Academic Works</li>
                                <li>Religion & Spirituality</li>
                              </ul>
                            </div>
                          </div>
                          <div className="col-4">
                            <div className="dropdown-column">
                              <h3>Creative Genres</h3>
                              <ul>
                                <li>Poetry & Anthologies</li>
                                <li>Graphic Novels & Comics</li>
                                <li>Cookbooks & Food Writing</li>
                                <li>Art & Photography Books</li>
                                <li>Children's Picture Books</li>
                                <li>Short Story Collections</li>
                                <li>Motivational Books</li>
                              </ul>
                            </div>
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>

                <Link
                  href="/genres"
                  className={
                    pathname === "/genres" ? "nav-item-active" : "nav-item"
                  }
                >
                  <span
                    className={
                      pathname === "/genres" ? "nav-text-active" : "nav-text"
                    }
                  >
                    Genres
                  </span>
                </Link>

                <Link
                  href="/blogs"
                  className={
                    pathname === "/blogs" ? "nav-item-active" : "nav-item"
                  }
                >
                  <span
                    className={
                      pathname === "/blogs" ? "nav-text-active" : "nav-text"
                    }
                  >
                    Blogs
                  </span>
                </Link>

                <Link
                  href="/testimonials"
                  className={
                    pathname === "/testimonials"
                      ? "nav-item-active"
                      : "nav-item"
                  }
                >
                  <span
                    className={
                      pathname === "/testimonials"
                        ? "nav-text-active"
                        : "nav-text"
                    }
                  >
                    Testimonials
                  </span>
                </Link>
              </nav>
            </div>

            <div className="col-lg-3 col-md-4 col-sm-6 col-4 d-flex justify-content-end align-items-center">
              <Link href="/contact-us" className="d-none d-lg-flex">
                <button className="contact-btn">Contact Us</button>
              </Link>
              <button
                className="mobile-toggle d-lg-none"
                onClick={toggleMenu}
                aria-label="Toggle navigation"
              >
                ☰
              </button>
            </div>
          </div>

          {/* Mobile Navigation */}
          <div className="row d-lg-none">
            <div className="col-12">
              <div className={`mobile-nav ${isMenuOpen ? "show" : ""}`}>
                <div
                  className={`mobile-nav-item ${
                    pathname === "/" ? "active" : ""
                  }`}
                  onClick={toggleMenu}
                >
                  <Link href="/">
                    <span className="mobile-nav-text">Home</span>
                  </Link>
                </div>

                <div
                  className={`mobile-nav-item ${
                    pathname === "/about-us" ? "active" : ""
                  }`}
                  onClick={toggleMenu}
                >
                  <Link href="/about-us">
                    <span className="mobile-nav-text">About us</span>
                  </Link>
                </div>

                {/* Mobile Services Dropdown */}
                <div
                  className={`mobile-nav-item ${
                    pathname === "/services" ? "active" : ""
                  }`}
                >
                  <div
                    onClick={toggleMobileServices}
                    // style={{ cursor: "pointer" }}
                  >
                    <Link href={"/services"}>
                      <span className="mobile-nav-text">
                        Services <span style={{ fontSize: "12px" }}>▼</span>
                      </span>
                    </Link>
                  </div>

                  <div
                    className={`mobile-services-dropdown ${
                      isMobileServicesOpen ? "show" : ""
                    }`}
                  >
                    {/* Promo Section */}
                    <div className="mobile-promo-section">
                      <h3>Launch Your Book</h3>
                      <p>50% Discount</p>
                      <Link href={"tel:12179069606"}>
                        <button className="promo-btn">
                          <svg
                            width="20"
                            height="20"
                            viewBox="0 0 29 29"
                            fill="none"
                          >
                            <path
                              d="M26.513 20.1969V24.7544C26.5131 25.0807 26.3851 25.3949 26.1547 25.6337C25.9243 25.8724 25.6087 26.0179 25.2715 26.0407C24.6887 26.0802 24.2126 26.1 23.8433 26.1C12.0472 26.1 2.48572 16.8677 2.48572 5.47777C2.48572 5.12204 2.50619 4.66234 2.54712 4.09866C2.57078 3.77314 2.72143 3.46841 2.96867 3.24594C3.21591 3.02348 3.54134 2.89985 3.8793 2.89999H8.59931C8.76489 2.89983 8.92461 2.9591 9.04746 3.06629C9.17031 3.17347 9.24751 3.32092 9.26407 3.47999C9.29432 3.77558 9.3228 4.01273 9.3495 4.19146C9.61476 5.97905 10.1584 7.71765 10.962 9.34831C11.0888 9.60608 11.006 9.91413 10.7658 10.0791L7.88517 12.0666C9.64679 16.029 12.9172 19.1868 17.0209 20.8877L19.0765 18.1115C19.1602 17.9976 19.2828 17.916 19.4227 17.8808C19.5626 17.8457 19.7109 17.8594 19.8414 17.9194C21.53 18.6939 23.3301 19.2175 25.1808 19.4725C25.3659 19.4983 25.6106 19.5258 25.9149 19.555C26.0794 19.5713 26.2318 19.646 26.3426 19.7646C26.4533 19.8832 26.5132 20.0372 26.513 20.1969Z"
                              fill="white"
                            />
                          </svg>
                          Call Now!
                        </button>
                      </Link>
                    </div>

                    {/* Services Links */}
                    <div className="mobile-dropdown-section">
                      <h4 className="mobile-dropdown-title">Services</h4>

                      <ul className="mobile-dropdown-list">
                        <li>
                          <Link href="/book-publishing" onClick={toggleMenu}>
                            Book Publishing
                          </Link>
                        </li>
                        <li>
                          <Link href="/book-writing" onClick={toggleMenu}>
                            Book Writing
                          </Link>
                        </li>
                        <li>
                          <Link href="/ghostwriting" onClick={toggleMenu}>
                            Ghostwriting
                          </Link>
                        </li>
                        <li>
                          <Link href="/book-editing" onClick={toggleMenu}>
                            Book Editing
                          </Link>
                        </li>
                        <li>
                          <Link
                            href="/proofreading-services"
                            onClick={toggleMenu}
                          >
                            Proofreading Services
                          </Link>
                        </li>
                        <li>
                          <Link
                            href="/formatting-services"
                            onClick={toggleMenu}
                          >
                            Formatting Services
                          </Link>
                        </li>
                        <li>
                          <Link href="/ebook-writing" onClick={toggleMenu}>
                            Ebook Writing
                          </Link>
                        </li>
                        <li>
                          <Link
                            href="/audio-book-recording"
                            onClick={toggleMenu}
                          >
                            Audio Book Recording
                          </Link>
                        </li>
                        <li>
                          <Link href="/book-cover-design" onClick={toggleMenu}>
                            Book Cover Design
                          </Link>
                        </li>
                        <li>
                          <Link
                            href="/children-book-writing"
                            onClick={toggleMenu}
                          >
                            Children's Book Writing
                          </Link>
                        </li>
                        <li>
                          <Link
                            href="/children-book-publication"
                            onClick={toggleMenu}
                          >
                            Children's Book Publication
                          </Link>
                        </li>
                        <li>
                          <Link
                            href="/children-book-illustrations"
                            onClick={toggleMenu}
                          >
                            Children's Book Illustrations
                          </Link>
                        </li>
                        <li>
                          <Link href="/book-marketing" onClick={toggleMenu}>
                            Book Marketing
                          </Link>
                        </li>
                        <li>
                          <Link href="/book-promotion" onClick={toggleMenu}>
                            Book Promotion
                          </Link>
                        </li>
                        <li>
                          <Link href="/author-marketing" onClick={toggleMenu}>
                            Author Marketing
                          </Link>
                        </li>
                        <li>
                          <Link
                            href="/book-trailer-production"
                            onClick={toggleMenu}
                          >
                            Book Trailer Production
                          </Link>
                        </li>
                        <li>
                          <Link href="/book-printing" onClick={toggleMenu}>
                            Book Printing
                          </Link>
                        </li>
                        <li>
                          <Link
                            href="/article-writing-and-publishing"
                            onClick={toggleMenu}
                          >
                            Article Writing & Publishing
                          </Link>
                        </li>
                        <li>
                          <Link href="/blog-writing" onClick={toggleMenu}>
                            Blog Writing
                          </Link>
                        </li>
                        <li>
                          <Link
                            href="/web-content-writing"
                            onClick={toggleMenu}
                          >
                            Web Content Writing
                          </Link>
                        </li>
                        <li>
                          <Link
                            href="/business-proposal-writing"
                            onClick={toggleMenu}
                          >
                            Business Proposal Writing
                          </Link>
                        </li>
                        <li>
                          <Link
                            href="/author-website-design"
                            onClick={toggleMenu}
                          >
                            Author Website Design
                          </Link>
                        </li>
                        <li>
                          <Link href="/translations" onClick={toggleMenu}>
                            Translations
                          </Link>
                        </li>
                      </ul>
                    </div>

                    {/* Genres Links */}
                    <div className="mobile-dropdown-section">
                      <h4 className="mobile-dropdown-title">Genres</h4>

                      <ul className="mobile-dropdown-list">
                        <h4>
                          <Link href="/" onClick={toggleMenu}>
                            Fiction Genres
                          </Link>
                        </h4>
                        <li>
                          <Link href="/" onClick={toggleMenu}>
                            Literary Fiction
                          </Link>
                        </li>
                        <li>
                          <Link href="/" onClick={toggleMenu}>
                            Historical Fiction
                          </Link>
                        </li>
                        <li>
                          <Link href="/" onClick={toggleMenu}>
                            Romance
                          </Link>
                        </li>
                        <li>
                          <Link href="/" onClick={toggleMenu}>
                            Mystery / Thriller / Suspense
                          </Link>
                        </li>
                        <li>
                          <Link href="/" onClick={toggleMenu}>
                            Science Fiction (Sci-Fi)
                          </Link>
                        </li>
                        <li>
                          <Link href="/" onClick={toggleMenu}>
                            Fantasy
                          </Link>
                        </li>
                        <li>
                          <Link href="/" onClick={toggleMenu}>
                            Adventure
                          </Link>
                        </li>
                        <li>
                          <Link href="/" onClick={toggleMenu}>
                            Horror
                          </Link>
                        </li>
                        <li>
                          <Link href="/" onClick={toggleMenu}>
                            Young Adult (YA) Fiction
                          </Link>
                        </li>
                        <li>
                          <Link href="/" onClick={toggleMenu}>
                            Children's Fiction
                          </Link>
                        </li>
                        <h4>
                          <Link href="/" onClick={toggleMenu}>
                            Non-Fiction Genres
                          </Link>
                        </h4>
                        <li>
                          <Link href="/" onClick={toggleMenu}>
                            Biographies & Memoirs
                          </Link>
                        </li>
                        <li>
                          <Link href="/" onClick={toggleMenu}>
                            Self-Help & Personal Development
                          </Link>
                        </li>
                        <li>
                          <Link href="/" onClick={toggleMenu}>
                            Business & Entrepreneurship
                          </Link>
                        </li>
                        <li>
                          <Link href="/" onClick={toggleMenu}>
                            Health, Wellness & Fitness
                          </Link>
                        </li>
                        <li>
                          <Link href="/" onClick={toggleMenu}>
                            History & Politics
                          </Link>
                        </li>
                        <li>
                          <Link href="/" onClick={toggleMenu}>
                            Travel & Adventure
                          </Link>
                        </li>
                        <li>
                          <Link href="/" onClick={toggleMenu}>
                            True Crime
                          </Link>
                        </li>
                        <li>
                          <Link href="/" onClick={toggleMenu}>
                            Science & Technology
                          </Link>
                        </li>
                        <li>
                          <Link href="/" onClick={toggleMenu}>
                            Education & Academic Works
                          </Link>
                        </li>
                        <li>
                          <Link href="/" onClick={toggleMenu}>
                            Religion & Spirituality
                          </Link>
                        </li>

                        <h4>
                          <Link href="/" onClick={toggleMenu}>
                            Creative Genres
                          </Link>
                        </h4>
                        <li>
                          <Link href="/" onClick={toggleMenu}>
                            Poetry & Anthologies
                          </Link>
                        </li>
                        <li>
                          <Link href="/" onClick={toggleMenu}>
                            Graphic Novels & Comics
                          </Link>
                        </li>
                        <li>
                          <Link href="/" onClick={toggleMenu}>
                            Cookbooks & Food Writing
                          </Link>
                        </li>
                        <li>
                          <Link href="/" onClick={toggleMenu}>
                            Art & Photography Books
                          </Link>
                        </li>
                        <li>
                          <Link href="/" onClick={toggleMenu}>
                            Children's Picture Books
                          </Link>
                        </li>
                        <li>
                          <Link href="/" onClick={toggleMenu}>
                            Short Story Collections
                          </Link>
                        </li>
                        <li>
                          <Link href="/" onClick={toggleMenu}>
                            Motivational Books
                          </Link>
                        </li>
                      </ul>
                    </div>
                  </div>
                </div>

                <div
                  className={`mobile-nav-item ${
                    pathname === "/genres" ? "active" : ""
                  }`}
                  onClick={toggleMenu}
                >
                  <Link href="/genres">
                    <span className="mobile-nav-text">Genres</span>
                  </Link>
                </div>

                <div
                  className={`mobile-nav-item ${
                    pathname === "/blogs" ? "active" : ""
                  }`}
                  onClick={toggleMenu}
                >
                  <Link href="/blogs">
                    <span className="mobile-nav-text">Blogs</span>
                  </Link>
                </div>

                <div
                  className={`mobile-nav-item ${
                    pathname === "/testimonials" ? "active" : ""
                  }`}
                  onClick={toggleMenu}
                >
                  <Link href="/testimonials">
                    <span className="mobile-nav-text">Testimonials</span>
                  </Link>
                </div>

                <Link href="/contact-us" onClick={toggleMenu}>
                  <button className="mobile-contact-btn">Contact Us</button>
                </Link>
              </div>
            </div>
          </div>
        </div>
      </header>
    </>
  );
};

export default Header;
