import React from "react";
import "./HeroSection.css";
import Image from "next/image";

const HeroSection = () => {
  return (
    <main className="hero-main container-fluid">
      <div className="hero-bg">
        <video autoPlay muted loop playsInline className="hero-video">
          <source src="/hero.mp4" type="video/mp4" />
        </video>
      </div>

      <div className="bg-blur-ellipse"></div>

      <div className="container-fluid px-0">
        <section className="row justify-content-center hero-content">
          <div className="col-12 col-md-10 col-lg-8 text-center">
            <h1 className="hero-title">
              Elume Publishers Can Take You towards Bestseller
            </h1>
            <h2 className="hero-subtitle">
              We are Offering High Quality eBook Comprehensive Services
            </h2>
          </div>
        </section>

        <div className="row justify-content-center hero-descriptions">
          <div className="col-12 col-md-10 col-lg-8 text-center">
            <p className="description-texts">
              Elume Publishers is the versatile place for publishing eBooks and
              ghostwriting facilities. We have world’s best professionals to
              serve.
            </p>
          </div>
        </div>

        <div className="row justify-content-center cta-section">
          <div className="col-auto">
            <button
              className="btn-request-quote"
              data-bs-toggle="modal"
              data-bs-target="#couponModal"
            >
              <div className="btn-circles">
                <span className="circle circle-1"></span>
                <span className="circle circle-2"></span>
                <span className="circle circle-3"></span>
                <span className="circle circle-4"></span>
              </div>
              <span className="btn-text">Request a Quote</span>
            </button>
          </div>
        </div>

        <section className="row books-showcase">
          <div className="col-12 position-relative" style={{ zIndex: 1 }}>
            <div className="books-blur"></div>

            <div className="books-container">
              <div className="book-item book-1">
                <Image
                  src="https://api.builder.io/api/v1/image/assets/TEMP/3cf5b1bcd9db1524296580221a18f4bd6516580b?width=663"
                  alt="Book cover"
                  width={500}
                  height={500}
                  className="book-image"
                />
              </div>
              <div className="book-item book-2">
                <Image
                  src="https://api.builder.io/api/v1/image/assets/TEMP/d704d97af14fa3fd899d93f8504f73d1991591e1?width=660"
                  alt="Book cover"
                  width={400}
                  height={400}
                  className="book-image"
                />
              </div>
              <div className="book-item book-3">
                <Image
                  src="https://api.builder.io/api/v1/image/assets/TEMP/29201343ad58b246ad4e970712e7d1f2d1047d24?width=660"
                  alt="Book cover"
                  width={500}
                  height={400}
                  className="book-image"
                />
              </div>
              <div className="book-item book-4">
                <Image
                  src="https://api.builder.io/api/v1/image/assets/TEMP/7f83321fb5633672d18cee3859c542262243c102?width=660"
                  alt="Book cover"
                  width={500}
                  height={400}
                  className="book-image"
                />
              </div>
              <div className="book-item book-5">
                <Image
                  src="https://api.builder.io/api/v1/image/assets/TEMP/d42377839d896c94f9e9ed680081f3c14d78f3d3?width=662"
                  alt="Book cover"
                  width={500}
                  height={400}
                  className="book-image"
                />
              </div>
            </div>
          </div>
        </section>

        <div className="bottom-gradient"></div>
      </div>
    </main>
  );
};

export default HeroSection;
