"use client";
import React from "react";
import "./ProcessSec.css";

const ProcessSection = () => {
  return (
    <>
      <section className="process-section-main">
        <div className="container-fluid">
          <div className="row justify-content-center">
            <div className="col-12">
              {/* Header Section */}
              <div className="row justify-content-center">
                <div className="col-lg-12 col-md-12">
                  <div className="process-header text-center">
                    <h3 className="processs-title">
                      Our{" "}
                      <span className="processs-title-highlight">
                        eBook Publishing
                      </span>{" "}
                      Process
                    </h3>
                    <p className="process-subtitle">
                      Publishing an eBook can seem tough but we have expert team
                      to look after all the burden. Elume Publishers offer
                      manageable steps to make the process smooth and efficient.
                    </p>
                  </div>
                </div>
              </div>

              <div className="row process-grid g-3">
                <div className="col-lg-3 col-md-6 col-12">
                  <div className="process-step-wrapper">
                    <div className="process-number">01</div>
                    <div className="process-content ">
                      <h3 className="process-step-title">
                        Planning & Content Creation
                      </h3>
                      <p className="process-step-description text-center">
                        Start by classifying target audience, establishing
                        goals, and making an outline. After having the plan
                        organized, start writing the content in a bid to
                        guarantee clarity, value, and organization.
                      </p>
                    </div>
                  </div>
                </div>
                <div className="col-lg-3 col-md-6 col-12">
                  <div className="process-step-wrapper process-step-wrapper2">
                    <div className="process-number process-number2">02</div>
                    <div className="process-content process-content2">
                      <h3 className="process-step-title">
                        Editing & <br /> Formatting
                      </h3>
                      <p className="process-step-description text-center">
                        After writing, edit books content for flow, grammar, and
                        reliability. Make the manuscript eBook-friendly (ePub,
                        MOBI, or PDF) for smooth reading across devices.
                      </p>
                    </div>
                  </div>
                </div>
                <div className="col-lg-3 col-md-6 col-12">
                  <div className="process-step-wrapper">
                    <div className="process-number">03</div>
                    <div className="process-content process-content3">
                      <h3 className="process-step-title">
                        Design & <br /> Packaging
                      </h3>
                      <p className="process-step-description text-center">
                        Produce an appealing cover and make sure the interior
                        design is qualified. A good cover is significant to
                        engage readers and build industry standard.
                      </p>
                    </div>
                  </div>
                </div>
                <div className="col-lg-3 col-md-6 col-12">
                  <div className="process-step-wrapper process-step-wrapper2">
                    <div className="process-number process-number4">04</div>
                    <div className="process-content process-content4">
                      <h3 className="process-step-title">
                        Publishing & Distribution
                      </h3>
                      <p className="process-step-description text-center">
                        Choosing a publishing platform (such as Amazon Kindle,
                        Apple Books, or Smashwords). Upload eBook, determine
                        pricing, and publish. Market the book in order to reach
                        accurate target audience effectively.
                      </p>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </section>
    </>
  );
};

export default ProcessSection;
