"use client";
import React from "react";
import "./Testimonials.css";
import Image from "next/image";
import { FiAirplay } from "react-icons/fi";
import { FaStar, FaRegStar } from "react-icons/fa";

const TestimonialCard = ({ type, name, role, image, testimonial, rating }) => {
  if (type === "video") {
    return (
      <div className="testimonial-video-card">
        <div className="video-content-container">
          <Image
            src={image}
            alt="Video testimonial background"
            fill
            className="video-background-image"
          />
          <button className="play-video-btn">
            <span className="play-btn-text">Play Video</span>
            <FiAirplay size={20} />
          </button>
          <p className="video-testimonial-text">{testimonial}</p>
        </div>
        <div className="testimonial-author-info">
          <div className="author-details">
            <h4 className="author-name">{name}</h4>
            <p className="author-role">{role}</p>
          </div>
        </div>
      </div>
    );
  }

  if (type === "image") {
    return (
      <div className="testimonial-image-card">
        <Image
          src={image}
          alt={`${name} testimonial`}
          width={351}
          height={440}
          className="testimonial-main-image"
        />
        <div className="testimonial-author-info">
          <div className="author-details">
            <h4 className="author-name">{name}</h4>
            <p className="author-role">{role}</p>
          </div>
        </div>
      </div>
    );
  }

  return (
    <div className="testimonial-detailed-card">
      <div className="detailed-card-header">
        <div className="author-info-section">
          <Image
            src={image}
            alt={`${name} profile`}
            width={351}
            height={440}
            className="author-profile-image"
          />
          <div className="author-text-info">
            <h4 className="author-name-detailed">{name}</h4>
            {/* <p className="author-role-detailed">{role}</p> */}
          </div>
        </div>
        <div className="rating-section">
          {[...Array(5)].map((_, i) =>
            i < rating ? (
              <FaStar key={i} className="star-icon" color="#f5c518" size={22} />
            ) : (
              <FaRegStar
                key={i}
                className="star-icon"
                color="#d1d5db"
                size={22}
              />
            )
          )}
        </div>
      </div>
      <div className="testimonial-divider"></div>
      <p className="testimonial-text">{testimonial}</p>
    </div>
  );
};

const TestimonialsSection = () => {
  const topTestimonials = [
    {
      type: "video",
      name: "Mark T",
      role: "Host of 'Tech Talks'",
      image:
        "https://api.builder.io/api/v1/image/assets/15161154b48645df88fb0490ee5cc09b/5f9b247ed5da17956e1438d6163ccd5a8c17e52f?placeholderIfAbsent=true",
      testimonial:
        "This platform transformed my podcasting journey with its intuitive tools and outstanding support!",
    },
    {
      type: "image",
      name: "Jessica M",
      role: "Host of 'Voices Unfiltered'",
      image:
        "https://api.builder.io/api/v1/image/assets/15161154b48645df88fb0490ee5cc09b/9660249b94c4d7d4f0f5b5d836e38e2fbc5d7776?placeholderIfAbsent=true",
    },
    {
      type: "image",
      name: "Ryan S",
      role: "Host of 'The Daily Update'",
      image:
        "https://api.builder.io/api/v1/image/assets/15161154b48645df88fb0490ee5cc09b/091bf988dc93abbb77c1fccfce3331002d4e4783?placeholderIfAbsent=true",
    },
  ];

  const bottomTestimonials = [
    {
      type: "detailed",
      name: " Caleb M",
      role: "Creative Director",
      image:
        "https://api.builder.io/api/v1/image/assets/15161154b48645df88fb0490ee5cc09b/86fde39a0cf7ad483053c6357a243c7be44921cf?placeholderIfAbsent=true",

      testimonial:
        "“The team truly captured my voice. It felt like reading my own thoughts, perfectly written and beautifully structured.”",
      rating: 5,
    },
    {
      type: "detailed",
      name: " Lena K",
      role: "Operations Lead",
      image:
        "https://api.builder.io/api/v1/image/assets/15161154b48645df88fb0490ee5cc09b/e27a52a48726c59193c2134482e749b5fa0e3fdb?placeholderIfAbsent=true",
      testimonial:
        " “They made the whole publishing process effortless! My ebook looks professional and reached readers faster than I expected.”",
      rating: 5,
    },
    {
      type: "detailed",
      name: "Tanya Brooks",
      role: "Marketing Specialist",
      image:
        "https://api.builder.io/api/v1/image/assets/15161154b48645df88fb0490ee5cc09b/4c584988b3f6ded7fd7201f9540ff7706012c9b7?placeholderIfAbsent=true",
      testimonial:
        "“The illustrations were full of life and color! Exactly what I imagined for my story, absolutely magical work.”",
      rating: 5,
    },
  ];

  return (
    <>
      <section className="testimonials-section-main">
        <div className="container-fluid">
          <div className="row justify-content-center">
            <div className="col-12">
              {/* Header Section */}
              <div className="row justify-content-center">
                <div className="col-xl-10 col-lg-11 col-md-12">
                  <div className="testimonials-header text-center">
                    <h2 className="testimonials-title">
                      What{" "}
                      <span className="testimonials-title-highlight">
                        Our Clients
                      </span>{" "}
                      Are Saying
                    </h2>
                    <p className="testimonials-subtitle">
                      See how we’ve empowered storytellers to publish with
                      confidence, quality, and wide-reaching impact
                    </p>
                  </div>
                </div>
              </div>

              {/* Top Row - Video and Image Testimonials */}
              <div className="row testimonials-top-row">
                <div className="col-xl-6 col-lg-6 col-md-12">
                  <TestimonialCard {...topTestimonials[0]} />
                </div>
                <div className="col-xl-3 col-lg-3 col-md-6">
                  <TestimonialCard {...topTestimonials[1]} />
                </div>
                <div className="col-xl-3 col-lg-3 col-md-6">
                  <TestimonialCard {...topTestimonials[2]} />
                </div>
              </div>

              {/* Bottom Row - Detailed Testimonials */}
              <div className="row testimonials-bottom-row">
                {bottomTestimonials.map((testimonial, index) => (
                  <div
                    key={index}
                    className="col-xl-4 col-lg-4 col-md-6 col-sm-12"
                  >
                    <TestimonialCard {...testimonial} />
                  </div>
                ))}
              </div>
            </div>
          </div>
        </div>
      </section>
    </>
  );
};

export default TestimonialsSection;
